/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server.defaultextensions;

import java.util.List;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.defaultextensions.RuntimeDefaultExtensions;
import org.mule.tooling.core.runtime.server.defaultextensions.internal.PojoRuntimeDefaultExtensions;
import org.mule.tooling.core.runtime.server.defaultextensions.internal.RuntimeDefaultExtensionsExtension;
import org.mule.tooling.utils.extensionpoint.FaultReporterAdapter;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;

public class RuntimeDefaultExtensionsManager {
    private final List<RuntimeDefaultExtensionsExtension> runtimeDefaultExtensions;

    public static RuntimeDefaultExtensionsManager instance() {
        return Singleton.instance;
    }

    private RuntimeDefaultExtensionsManager() {
        this(RuntimeDefaultExtensionsManager.loadExtensions());
    }

    public RuntimeDefaultExtensionsManager(List<RuntimeDefaultExtensionsExtension> runtimeDefaultExtensions) {
        this.runtimeDefaultExtensions = runtimeDefaultExtensions;
    }

    private static List<RuntimeDefaultExtensionsExtension> loadExtensions() {
        return IExtensionPointReader.create(RuntimeDefaultExtensionsExtension.class).readAll((IFaultReporter)new FaultReporterAdapter(){

            protected void handleGeneralFault(String description) {
                MuleCorePlugin.logWarning("There was a problem reading default modules extension: " + description);
            }
        });
    }

    public RuntimeDefaultExtensions getDefaultsConfiguration(IServerDefinition server) {
        RuntimeDefaultExtensionsExtension matchingExtension = this.runtimeDefaultExtensions.stream().filter(ext -> ext.matches(server)).sorted((ext1, ext2) -> ext2.getPriority() - ext1.getPriority()).findFirst().orElseThrow(() -> new IllegalStateException("A default default extensions extension should always be registered"));
        return new PojoRuntimeDefaultExtensions(matchingExtension.getDefaultExtensions(), matchingExtension.getNewProjectDefaultExtensions());
    }

    private static class Singleton {
        private static final RuntimeDefaultExtensionsManager instance = new RuntimeDefaultExtensionsManager();

        private Singleton() {
        }
    }
}

