/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerDefinition;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class ServerMatcher {
    private static final String LEFT_DELIM = "[\\[\\(]?";
    private static final String VERSION_INNER = "[0-9.,]+";
    private static final String RIGHT_DELIM = "[\\]\\)]?";
    private static final String SERVER_MATCHER_REGEX = "(mule|gateway)?([\\[\\(]?[0-9.,]+[\\]\\)]?)\\.?(ee|ce)?";
    private VersionRange versionRange;
    private Version version;
    private String qualifier;

    public static ServerMatcher valueOf(String expression) {
        Matcher matcher = Pattern.compile(SERVER_MATCHER_REGEX).matcher(expression);
        if (matcher.matches()) {
            return new ServerMatcher(matcher.group(2), matcher.group(3));
        }
        return null;
    }

    public static ServerMatcher fromString(String expression) {
        return ServerMatcher.valueOf(expression);
    }

    public ServerMatcher(String version, String qualifier) {
        if (version.contains(",")) {
            this.versionRange = new VersionRange(version);
        } else {
            this.version = Version.parseVersion((String)this.extractInnerVersion(version));
        }
        this.qualifier = qualifier;
    }

    public String extractInnerVersion(String version) {
        Matcher matcher = Pattern.compile("[\\[\\(]?([0-9.,]+)[\\]\\)]?").matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(version);
        }
        return matcher.group(1);
    }

    public VersionRange getVersionRange() {
        return this.versionRange;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public boolean matches(IServerDefinition serverDefinition) {
        return this.matches(this.getVersionFromServer(serverDefinition), serverDefinition.isEnterpriseRuntime());
    }

    public boolean matches(Version serverVersion, Boolean isEnterprise) {
        boolean versionMatches;
        boolean bl = versionMatches = this.version != null ? this.versionMatches(serverVersion, this.version) : this.versionMatches(serverVersion, this.versionRange);
        if (versionMatches) {
            if ("ee".equals(this.qualifier)) {
                return isEnterprise;
            }
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean matches(ServerDefinition serverDefinition) {
        return this.matches((IServerDefinition)serverDefinition);
    }

    private boolean versionMatches(Version server, Version version) {
        return server.equals((Object)version);
    }

    private boolean versionMatches(Version server, VersionRange versionRange) {
        return versionRange.includes(server);
    }

    private Version getVersionFromServer(IServerDefinition server) {
        return Version.parseVersion((String)server.getVersion());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.versionRange == null ? 0 : this.versionRange.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ServerMatcher other = (ServerMatcher)obj;
        if (this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals((Object)other.version)) {
            return false;
        }
        return !(this.versionRange == null ? other.versionRange != null : !this.versionRange.equals((Object)other.versionRange));
    }

    public String toString() {
        return "ServerMatcher [versionRange=" + String.valueOf(this.versionRange) + ", version=" + String.valueOf(this.version) + ", qualifier=" + this.qualifier + "]";
    }
}

