/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.module.MuleModuleManagerFactory;
import org.mule.tooling.core.runtime.internal.OverrideDebuggerInServer;
import org.mule.tooling.core.runtime.server.ClasspathElementDefinition;
import org.mule.tooling.core.runtime.server.ConfigFolderDefinition;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.LibraryFolderDefinition;
import org.mule.tooling.core.runtime.server.MuleLauncherClasspathElement;
import org.mule.tooling.core.runtime.server.MuleServerContext;
import org.mule.tooling.core.runtime.server.SchemaLocationEntry;
import org.mule.tooling.core.runtime.server.SchemaLocationLookup;
import org.mule.tooling.core.runtime.server.SchemaLocationLookupExtension;
import org.mule.tooling.core.runtime.server.defaultextensions.RuntimeDefaultExtensions;
import org.mule.tooling.core.runtime.server.defaultextensions.internal.PojoRuntimeDefaultExtensions;
import org.mule.tooling.core.runtime.server.defaultextensions.internal.RuntimeDefaultExtensionsExtension;
import org.mule.tooling.core.runtime.server.extensionpoint.ServiceFolderDefinition;
import org.mule.tooling.core.runtime.sources.SourceAttachmentPreferences;
import org.mule.tooling.core.utils.VersionComparator;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.osgi.framework.Bundle;

public class ServerDefinition
implements IServerDefinition {
    public static final String EE_SIGN = ";";
    private final String id;
    private final String label;
    private final String version;
    private final String versionSuffix;
    private final String debuggerVersion;
    private final boolean enterpriseRuntime;
    private final IPath sourceFilePath;
    private final IPath pluginBaseDirectory;
    private final List<LibraryFolderDefinition> libraryFolders;
    private final List<ConfigFolderDefinition> configFolders;
    private final List<ClasspathElementDefinition> classpathElements;
    private final IMuleModuleManager moduleManager;
    private final RuntimeDefaultExtensions runtimeDefaultExtensions;
    private final ISchemaLocationLookup schemaLocationlookup;
    private IPath enterpriseSourceFilePath;

    public static Builder builder(Bundle bundle) {
        return new Builder(bundle);
    }

    private ServerDefinition(String id, String label, String version, String versionSuffix, String debuggerVersion, boolean enterpriseRuntime, IMuleModuleManager moduleManager, IPath sourceFilePath, IPath enterpriseSourceFilePath, IPath pluginBaseDirectory, List<LibraryFolderDefinition> libraryFolders, List<ConfigFolderDefinition> configFolders, List<ClasspathElementDefinition> classpathElements, RuntimeDefaultExtensions runtimeDefaultExtensions, SchemaLocationLookup locationLookup) {
        this.id = id;
        this.label = label;
        this.version = version;
        this.versionSuffix = versionSuffix;
        this.moduleManager = moduleManager;
        this.debuggerVersion = debuggerVersion;
        this.enterpriseRuntime = enterpriseRuntime;
        this.sourceFilePath = sourceFilePath;
        this.enterpriseSourceFilePath = enterpriseSourceFilePath;
        this.pluginBaseDirectory = pluginBaseDirectory;
        this.libraryFolders = libraryFolders;
        this.configFolders = configFolders;
        this.classpathElements = classpathElements;
        this.runtimeDefaultExtensions = runtimeDefaultExtensions;
        this.schemaLocationlookup = locationLookup;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getVersionSuffix() {
        return this.versionSuffix;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getVersionWithPatchVersionZero() {
        CharSequence[] versionParts = this.getVersion().split("\\.");
        if (versionParts.length < 3) {
            return this.getVersion();
        }
        versionParts[2] = "0";
        return String.join((CharSequence)".", versionParts);
    }

    @Override
    public String getVersionWithEESign() {
        if (this.isEnterpriseRuntime()) {
            return this.version + EE_SIGN;
        }
        return this.version;
    }

    @Override
    public String getDebuggerVersion() {
        return this.debuggerVersion;
    }

    @Override
    public IPath getSourceFilePath() {
        return this.sourceFilePath;
    }

    @Override
    public IPath getEnterpriseSourceFilePath() {
        return this.enterpriseSourceFilePath;
    }

    @Override
    public List<LibraryFolderDefinition> getLibraryFolders() {
        return this.libraryFolders;
    }

    @Override
    public List<ConfigFolderDefinition> getConfigFolders() {
        return this.configFolders;
    }

    @Override
    public ISchemaLocationLookup getSchemaLocationlookup() {
        return this.schemaLocationlookup;
    }

    @Override
    public int compareTo(IServerDefinition other) {
        return this.getVersion().compareTo(other.getVersion());
    }

    @Override
    public boolean isEnterpriseRuntime() {
        return this.enterpriseRuntime;
    }

    @Override
    public String getVersionWithSuffix() {
        return ServerDefinition.getVersionWithSuffix(this.getVersion(), this.getVersionSuffix());
    }

    private static String getVersionWithSuffix(String version, String suffix) {
        Object versionWithSuffix = null;
        versionWithSuffix = !StringUtils.isEmpty((String)suffix) ? version + "-" + suffix : version;
        return versionWithSuffix;
    }

    @Override
    public int getVersionNumber() {
        int intVersion = 0;
        String version = this.version;
        String[] splitVersion = version.split("\\.");
        int i = 0;
        while (i < splitVersion.length) {
            if (splitVersion[i].contains("-")) {
                splitVersion[i] = splitVersion[i].substring(0, splitVersion[i].indexOf("-"));
            }
            ++i;
        }
        if (splitVersion.length >= 3) {
            intVersion = 100 * Integer.valueOf(splitVersion[0]) + 10 * Integer.valueOf(splitVersion[1]) + Integer.valueOf(splitVersion[2]);
        }
        return intVersion;
    }

    @Override
    public List<ClasspathElementDefinition> getClasspathElements() {
        return this.classpathElements;
    }

    @Override
    public IPath getPluginBaseDirectory() {
        return this.pluginBaseDirectory;
    }

    @Override
    public int compareVersionTo(String otherVersion) {
        return VersionComparator.forVersion(this.version).compareVersionTo(otherVersion);
    }

    @Override
    public Collection<MuleLauncherClasspathElement> getMuleLauncherClasspathElements() {
        ArrayList<MuleLauncherClasspathElement> candidates = new ArrayList<MuleLauncherClasspathElement>(this.getClasspathElements().size() + this.getLibraryFolders().size());
        candidates.addAll(this.getClasspathElements());
        candidates.addAll(this.getLibraryFolders());
        CollectionUtils.filter(candidates, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                MuleLauncherClasspathElement classpathElement = (MuleLauncherClasspathElement)object;
                return classpathElement.isInLauncherClasspath();
            }
        });
        Collections.sort(candidates, new Comparator<MuleLauncherClasspathElement>(){

            @Override
            public int compare(MuleLauncherClasspathElement e1, MuleLauncherClasspathElement e2) {
                if (e1.getRuntimeLauncherClasspathOrder() != null && e2.getRuntimeLauncherClasspathOrder() != null) {
                    return e1.getRuntimeLauncherClasspathOrder().compareTo(e2.getRuntimeLauncherClasspathOrder());
                }
                if (e1.getRuntimeLauncherClasspathOrder() != null && e2.getRuntimeLauncherClasspathOrder() == null) {
                    return 1;
                }
                if (e2.getRuntimeLauncherClasspathOrder() != null) {
                    return -1;
                }
                return 0;
            }
        });
        return candidates;
    }

    @Override
    public MuleLauncherClasspathElement getToolingSupportFolder() {
        return this.getLibraryFolderFolder("Tooling Support");
    }

    @Override
    public MuleLauncherClasspathElement getEndorsedFolder() {
        return this.getLibraryFolderFolder("Endorsed Libraries");
    }

    @Override
    public MuleLauncherClasspathElement getMuleCorePerAppFolder() {
        return this.getLibraryFolderFolder("Mule Core Libraries (per app)");
    }

    @Override
    public LibraryFolderDefinition getMuleCoreLibrariesFolder() {
        return this.getLibraryFolderFolder("Mule Core Libraries");
    }

    @Override
    public LibraryFolderDefinition getLibraryFolderFolder(String label) {
        LibraryFolderDefinition libFolder = null;
        for (LibraryFolderDefinition library : this.getLibraryFolders()) {
            if (label == null || !label.equals(library.getLabel())) continue;
            libFolder = library;
            break;
        }
        if (libFolder != null) {
            return libFolder;
        }
        MuleCorePlugin.logWarning("Server definition does not have a library folder labeled " + label, null);
        return null;
    }

    @Override
    public IMuleModuleManager getModuleManager() {
        return this.moduleManager;
    }

    @Override
    public RuntimeDefaultExtensions getRuntimeDefaultExtensions() {
        return this.runtimeDefaultExtensions;
    }

    @Override
    public void setEnterpriseSourceFilePath(IPath path) {
        this.enterpriseSourceFilePath = path;
    }

    public String toString() {
        return "ServerDefinition [label=" + this.label + ", id=" + this.id + ", version=" + this.version + "]";
    }

    public static class Builder {
        private final Bundle bundle;
        private String id;
        private String label;
        private String version;
        private String versionSuffix;
        private String debuggerVersion;
        private boolean enterpriseRuntime = false;
        private String sourceFilePath;
        private IPath enterpriseSourceFilePath;
        private List<LibraryFolderDefinition> libraryFolders = Collections.emptyList();
        private List<ConfigFolderDefinition> configFolders = Collections.emptyList();
        private List<ClasspathElementDefinition> classpathElements = Collections.emptyList();
        private List<ServiceFolderDefinition> serviceFolders = Collections.emptyList();
        private List<SchemaLocationLookupExtension> schemaLocationLookups = Collections.emptyList();
        private List<RuntimeDefaultExtensionsExtension> runtimeDefaultExtensions = Collections.emptyList();

        private Builder(Bundle bundle) {
            this.bundle = bundle;
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withVersionSuffix(String versionSuffix) {
            this.versionSuffix = versionSuffix;
            return this;
        }

        public Builder withDebuggerVersion(String debuggerVersion) {
            this.debuggerVersion = debuggerVersion;
            return this;
        }

        public Builder enterpriseRuntime(boolean enterpriseRuntime) {
            this.enterpriseRuntime = enterpriseRuntime;
            return this;
        }

        public Builder withSourceFilePath(String sourceFilePath) {
            this.sourceFilePath = sourceFilePath;
            return this;
        }

        public Builder withEnterpriseSourceFilePath(IPath enterpriseSourceFilePath) {
            this.enterpriseSourceFilePath = enterpriseSourceFilePath;
            return this;
        }

        public Builder withLibraryFolders(List<LibraryFolderDefinition> libraryFolders) {
            this.libraryFolders = libraryFolders;
            return this;
        }

        public Builder withConfigFolders(List<ConfigFolderDefinition> configFolders) {
            this.configFolders = configFolders;
            return this;
        }

        public Builder withServiceFolders(List<ServiceFolderDefinition> serviceFolders) {
            this.serviceFolders = serviceFolders;
            return this;
        }

        public Builder withClasspathElements(List<ClasspathElementDefinition> classpathElements) {
            this.classpathElements = classpathElements;
            return this;
        }

        public Builder withSchemaLocationLookups(List<SchemaLocationLookupExtension> schemaLocationLookups) {
            this.schemaLocationLookups = schemaLocationLookups;
            return this;
        }

        public Builder withRuntimeDefaultExtensions(List<RuntimeDefaultExtensionsExtension> runtimeDefaultExtensions) {
            this.runtimeDefaultExtensions = runtimeDefaultExtensions;
            return this;
        }

        private List<LibraryFolderDefinition> getAllLibraryFolders() {
            List serviceFolderLibraries = this.serviceFolders.stream().flatMap(folder -> folder.getLibraryFolderDefinitions().stream()).collect(Collectors.toList());
            ArrayList<LibraryFolderDefinition> allLibraryFolders = new ArrayList<LibraryFolderDefinition>(this.libraryFolders.size() + serviceFolderLibraries.size());
            allLibraryFolders.addAll(this.libraryFolders);
            allLibraryFolders.addAll(serviceFolderLibraries);
            return allLibraryFolders;
        }

        public RuntimeDefaultExtensions getDefaultsConfiguration() {
            RuntimeDefaultExtensionsExtension matchingExtension = (RuntimeDefaultExtensionsExtension)this.runtimeDefaultExtensions.stream().sorted((ext1, ext2) -> ext2.getPriority() - ext1.getPriority()).findFirst().orElseThrow(() -> new IllegalStateException("A default default extensions extension should always be registered"));
            return new PojoRuntimeDefaultExtensions(matchingExtension.getDefaultExtensions(), matchingExtension.getNewProjectDefaultExtensions());
        }

        private SchemaLocationLookup getSchemaLocationLookup() {
            List<SchemaLocationEntry> entries = Optional.ofNullable(this.schemaLocationLookups).orElseGet(() -> Collections.emptyList()).stream().flatMap(extension -> extension.getSchemaLocations().stream()).collect(Collectors.toList());
            return new SchemaLocationLookup(this.bundle, entries);
        }

        public ServerDefinition build() throws IOException {
            IPath pluginBaseDirectory = null;
            IPath _sourceFilePath = null;
            File bundleFile = FileLocator.getBundleFile((Bundle)this.bundle);
            pluginBaseDirectory = Path.fromOSString((String)bundleFile.getAbsoluteFile().toString());
            _sourceFilePath = pluginBaseDirectory.append((IPath)new Path(this.sourceFilePath));
            List<LibraryFolderDefinition> allLibraryFolders = this.getAllLibraryFolders();
            MuleServerContext context = new MuleServerContext(Paths.get(pluginBaseDirectory.toString(), new String[0]), this.version, this.versionSuffix, this.enterpriseRuntime);
            List extensions = IExtensionPointReader.create(OverrideDebuggerInServer.class).readAll();
            Optional<OverrideDebuggerInServer> overrideDebuggerContribution = extensions.stream().filter(ext -> ext.applies(context)).findFirst();
            overrideDebuggerContribution.ifPresent(contribution -> this.applyIfNotSatisfied(context, (OverrideDebuggerInServer)contribution));
            IMuleModuleManager moduleManager = MuleModuleManagerFactory.createModuleManager(this.version + (this.enterpriseRuntime ? ServerDefinition.EE_SIGN : ""));
            if (this.enterpriseRuntime) {
                Optional<String> maybeSourceAttachment = SourceAttachmentPreferences.get().getSourceAttachment(this.id);
                maybeSourceAttachment.map(Path::fromOSString).ifPresent(path -> {
                    Builder builder = this.withEnterpriseSourceFilePath((IPath)path);
                });
            }
            RuntimeDefaultExtensions defaultsConfiguration = this.getDefaultsConfiguration();
            SchemaLocationLookup locationLookup = this.getSchemaLocationLookup();
            return new ServerDefinition(this.id, this.label, this.version, this.versionSuffix, this.debuggerVersion, this.enterpriseRuntime, moduleManager, _sourceFilePath, this.enterpriseSourceFilePath, pluginBaseDirectory, allLibraryFolders, this.configFolders, this.classpathElements, defaultsConfiguration, locationLookup);
        }

        private void applyIfNotSatisfied(MuleServerContext context, OverrideDebuggerInServer contribution) {
            try {
                if (contribution.applies(context)) {
                    if (!contribution.isSatisfied(context)) {
                        contribution.installContribution(context);
                    } else {
                        System.out.println("Skipping contribution as it is already satisfied");
                    }
                    this.debuggerVersion = contribution.getDebuggerVersion();
                }
            }
            catch (Exception ex) {
                MuleCorePlugin.logError("Unexpected error preparing the debugger.", ex);
            }
        }
    }
}

