/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Namespace;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.SchemaLocationEntry;
import org.mule.tooling.core.runtime.server.SchemaLocationLookupExtension;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public class SchemaLocationLookupManager {
    private List<SchemaLocationLookupExtension> schemaLocationsExtensions = new ArrayList<SchemaLocationLookupExtension>();
    private Set<Namespace> allNamespaces;

    public static SchemaLocationLookupManager instance() {
        return Singleton.instance;
    }

    private SchemaLocationLookupManager() {
        this.initializeExtensions();
        this.initializeAllNamespaces();
    }

    private void initializeExtensions() {
        IExtensionPointReader reader = IExtensionPointReader.create(SchemaLocationLookupExtension.class);
        this.schemaLocationsExtensions = reader.readAll();
    }

    public List<SchemaLocationEntry> getSchemaLocations(IServerDefinition server) {
        HashSet<SchemaLocationEntry> schemaLocations = new HashSet<SchemaLocationEntry>();
        for (SchemaLocationLookupExtension entry : this.schemaLocationsExtensions) {
            if (!entry.matches(server)) continue;
            schemaLocations.addAll(entry.getSchemaLocations());
        }
        return new ArrayList<SchemaLocationEntry>(schemaLocations);
    }

    public Set<Namespace> getAllNamespaces() {
        return this.allNamespaces;
    }

    private void initializeAllNamespaces() {
        HashSet<Namespace> allNamespacesSet = new HashSet<Namespace>();
        List<SchemaLocationLookupExtension> values = this.schemaLocationsExtensions;
        for (SchemaLocationLookupExtension extension : values) {
            for (SchemaLocationEntry schemaLocationEntry : extension.getSchemaLocations()) {
                allNamespacesSet.add(schemaLocationEntry.getNamespaceObject());
            }
        }
        this.allNamespaces = allNamespacesSet;
    }

    private static class Singleton {
        private static final SchemaLocationLookupManager instance = new SchemaLocationLookupManager();

        private Singleton() {
        }
    }
}

