/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.SchemaLocationEntry;
import org.mule.tooling.core.runtime.server.ServerMatcher;
import org.mule.tooling.core.runtime.server.extensionpoint.ServerFiltering;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionChildElement;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;

@ExtensionPoint(extensionPointId="org.mule.tooling.servers.commons.schemaLocationLookup")
public class SchemaLocationLookupExtension
implements ServerFiltering {
    public static final String EXT_POINT_ID = "org.mule.tooling.servers.commons.schemaLocationLookup";
    @ExtensionAttribute(optional=true)
    private String serverId;
    @ExtensionChildElement(childElementsName="schemaLocation", elementType=SchemaLocationEntry.class)
    private List<SchemaLocationEntry> schemaLocations;
    @ExtensionChildElement(childElementsName="server", elementType=ServerMatcher.class, attributeName="matcher")
    private List<ServerMatcher> targetServers;

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public List<SchemaLocationEntry> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(List<SchemaLocationEntry> schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    public List<ServerMatcher> getTargetServers() {
        return this.targetServers;
    }

    public void setTargetServers(List<ServerMatcher> targetServers) {
        this.targetServers = targetServers;
    }

    @Override
    public boolean matches(IServerDefinition server) {
        if (StringUtils.isNotEmpty((String)this.serverId)) {
            return server.getId().matches(this.serverId);
        }
        for (ServerMatcher matcher : this.targetServers) {
            if (!matcher.matches(server)) continue;
            return true;
        }
        return false;
    }
}

