/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dom4j.Namespace;
import org.eclipse.core.resources.IProject;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.IMuleRuntimeChangedListener;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.runtime.server.BaseAbstractSchemaLocationLookup;
import org.mule.tooling.core.runtime.server.ExternalContributionSchemaLookup;
import org.mule.tooling.core.runtime.server.ILocalSchemaLookup;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class ProjectSchemaLocationLookup
implements ISchemaLocationLookup,
ILocalSchemaLookup {
    private BaseAbstractSchemaLocationLookup decorated;
    private Map<EditingScope, ExternalContributionSchemaLookup> externalContributions = new ConcurrentHashMap();
    private final EventBusHelper eventBusHelper = new EventBusHelper();
    private IProject muleProjectResource;

    public ProjectSchemaLocationLookup(IMuleProject muleProject) {
        this.muleProjectResource = muleProject.getProject();
        this.decorated = this.getServerSchemaLocationLookup(muleProject);
        this.registerListener();
    }

    private BaseAbstractSchemaLocationLookup getServerSchemaLocationLookup(IMuleProject muleProject) {
        ISchemaLocationLookup schemaLocationlookup = muleProject.getServerDefinition().getSchemaLocationlookup();
        if (!(schemaLocationlookup instanceof BaseAbstractSchemaLocationLookup)) {
            throw new RuntimeException("Expected an instanceof " + BaseAbstractSchemaLocationLookup.class.getName() + " but got instead a " + schemaLocationlookup.getClass().getName());
        }
        return (BaseAbstractSchemaLocationLookup)schemaLocationlookup;
    }

    private void registerListener() {
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_RUNTIME_CHANGED, (IEventHandler)new IMuleRuntimeChangedListener(){

            @Override
            public void beforeChanging(String fromId, String toId, IMuleProject muleProject) {
            }

            @Override
            public void afterChanging(String fromId, String toId, IMuleProject muleProject) {
                if (ProjectSchemaLocationLookup.this.belongsToMe(muleProject.getProject())) {
                    ProjectSchemaLocationLookup.this.decorated = ProjectSchemaLocationLookup.this.getServerSchemaLocationLookup(muleProject);
                }
            }
        });
        IMuleProjectEventListener projectListener = new IMuleProjectEventListener(){

            @Override
            public void onMuleProjectOpened(IProject project) {
            }

            @Override
            public void onMuleProjectClosed(IProject project) {
                if (ProjectSchemaLocationLookup.this.belongsToMe(project)) {
                    ProjectSchemaLocationLookup.this.eventBusHelper.unregister();
                }
            }
        };
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)projectListener);
    }

    public void updateIfRequired(IMuleModuleManager muleModuleManager) {
        this.externalContributions.clear();
    }

    private boolean belongsToMe(IProject project) {
        return project.equals((Object)this.muleProjectResource);
    }

    @Override
    public String getSchemaLocation(Namespace namespace) {
        String schemaLocation = this.decorated.getSchemaLocation(namespace);
        if (schemaLocation == null) {
            schemaLocation = this.getSchemaLookupFromExternalContributions().getSchemaLocation(namespace);
        }
        if (schemaLocation == null) {
            ExternalContributionSchemaLookup fallback = this.getSchemaLookupFromModulesNotInProject();
            schemaLocation = fallback.getSchemaLocation(namespace);
        }
        return schemaLocation;
    }

    @Override
    public String getSchemaLocationByUri(String uri) {
        String schemaLocationByUri = this.decorated.getSchemaLocationByUri(uri);
        if (schemaLocationByUri == null) {
            schemaLocationByUri = this.getSchemaLookupFromExternalContributions().getSchemaLocationByUri(uri);
        }
        if (schemaLocationByUri == null) {
            ExternalContributionSchemaLookup fallback = this.getSchemaLookupFromModulesNotInProject();
            schemaLocationByUri = fallback.getSchemaLocationByUri(uri);
        }
        return schemaLocationByUri;
    }

    private ExternalContributionSchemaLookup getSchemaLookupFromModulesNotInProject() {
        Object muleProject;
        if (this.muleProjectResource.isAccessible() && (muleProject = MuleRuntime.create(this.muleProjectResource)) != null) {
            List<ExternalContributionMuleModule> projectExternalModules = muleProject.getModuleManager().getExternalModules();
            List<ExternalContributionMuleModule> allModulesForServer = MuleCorePlugin.getModuleContributionManager().getExternalModules(muleProject.getServerDefinition());
            List<ExternalContributionMuleModule> candidates = allModulesForServer.stream().filter(x -> !projectExternalModules.contains(x)).collect(Collectors.toList());
            return new ExternalContributionSchemaLookup(candidates);
        }
        return new ExternalContributionSchemaLookup(Collections.emptyList());
    }

    private ExternalContributionSchemaLookup getSchemaLookupFromExternalContributions() {
        return this.externalContributions.computeIfAbsent(EditingScope.getCurrent(), scope -> {
            Object muleProject;
            if (this.muleProjectResource.isAccessible() && (muleProject = MuleRuntime.create(this.muleProjectResource)) != null) {
                List<ExternalContributionMuleModule> projectExternalModules = muleProject.getModuleManager().getExternalModules();
                return new ExternalContributionSchemaLookup(projectExternalModules);
            }
            return new ExternalContributionSchemaLookup(Collections.emptyList());
        });
    }

    @Override
    public String getSchemaUrl(String muleConfigUri, String schema, String schemaLocationUri) {
        String schemaUrl = this.decorated.getSchemaUrl(muleConfigUri, schema, schemaLocationUri);
        if (schemaUrl == null) {
            schemaUrl = this.getSchemaLookupFromExternalContributions().getSchemaUrl(muleConfigUri, schema, schemaLocationUri);
        }
        if (schemaUrl == null) {
            ExternalContributionSchemaLookup fallback = this.getSchemaLookupFromModulesNotInProject();
            schemaUrl = fallback.getSchemaUrl(muleConfigUri, schemaUrl, schemaLocationUri);
        }
        return schemaUrl;
    }

    @Override
    public String getNamespaceUriByPrefix(String prefix) {
        String namespaceUri = this.decorated.getNamespaceUriByPrefix(prefix);
        if (namespaceUri == null) {
            namespaceUri = this.getSchemaLookupFromExternalContributions().getNamespaceUriByPrefix(prefix);
        }
        if (namespaceUri == null) {
            ExternalContributionSchemaLookup fallback = this.getSchemaLookupFromModulesNotInProject();
            namespaceUri = fallback.getNamespaceUriByPrefix(prefix);
        }
        return namespaceUri;
    }
}

