/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerDefinition;
import org.mule.tooling.core.runtime.server.extensionpoint.ServerDefinitionExtension;
import org.mule.tooling.core.utils.StartsWithSearchingMap;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;

public class MuleServerManager {
    public static final String ATT_LAUNCH_ORDER = "runtimeLauncherClasspathOrder";
    public static final String ELM_SERVER = "server";
    public static final String ELM_LIBRARY_FOLDER = "libraryFolder";
    public static final String ELM_SERVICE_FOLDER = "serviceFolder";
    public static final String ELM_CONFIG_FOLDER = "configFolder";
    public static final String ELM_CLASSPATH_ELEMENT = "classpath";
    public static final String ELM_EXAMPLE = "example";
    public static final String ATT_ID = "id";
    public static final String ATT_LABEL = "label";
    public static final String ATT_DEBUGGER_VERSION = "debuggerVersion";
    public static final String ATT_VERSION = "version";
    public static final String ATT_VERSION_SUFFIX = "versionSuffix";
    public static final String ATT_ENTERPRISE_RUNTIME = "enterpriseRuntime";
    public static final String ATT_SOURCE_PATH = "sourcePath";
    public static final String ATT_PATH = "path";
    public static final String ATT_INCLUDE_IN_CONTAINER = "includeInContainer";
    public static final String ATT_SCHEMA_LOCATION_LOOKUP = "schemaLocationLookup";
    public static final String ATT_DESCRIPTION = "description";
    public static final String ELM_CLASSPATH_INCLUSION = "classpathInclusion";
    public static final String ELM_CLASSPATH_EXCLUSION = "classpathExclusion";
    public static final String ATT_INCLUSION_OR_EXCLUSION_REGEX = "regex";
    private final Map<String, IServerDefinition> servers = new HashMap<String, IServerDefinition>();
    private volatile List<IServerDefinition> sorted;
    private final StartsWithSearchingMap<IServerDefinition> serverPathToServerMap;
    private final Object lock = new Object();

    public static MuleServerManager instance() {
        return MuleServerManagerSingleton.instance;
    }

    private MuleServerManager() {
        this.serverPathToServerMap = new StartsWithSearchingMap();
        System.nanoTime();
        List serverDefinitionExtensions = IExtensionPointReader.create(ServerDefinitionExtension.class).readAll();
        System.nanoTime();
        for (ServerDefinitionExtension extension : serverDefinitionExtensions) {
            block9: {
                System.nanoTime();
                ServerDefinition server = null;
                try {
                    try {
                        server = extension.buildServerDefinition();
                        this.internalAddServerDefinition(server);
                    }
                    catch (Exception e) {
                        MuleCorePlugin.logError("There was a problem loading server extension from bundle " + extension.getBundle().getSymbolicName(), e);
                        if (server == null) {
                            System.err.println("Failed to load " + extension.getServerId());
                        }
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    if (server == null) {
                        System.err.println("Failed to load " + extension.getServerId());
                    }
                    throw throwable;
                }
                if (server == null) {
                    System.err.println("Failed to load " + extension.getServerId());
                }
            }
            System.nanoTime();
        }
    }

    public IServerDefinition addServerDefinition(IServerDefinition server) {
        String callerClassName = Thread.currentThread().getStackTrace()[2].getClassName();
        if (!callerClassName.matches("org\\.mule\\.tooling[a-zA-Z\\.]*\\.test(s?)\\..*") && !callerClassName.matches("org\\.mule\\.tooling[a-zA-Z\\.]*\\..*Test(s?).*")) {
            throw new AssertionError((Object)"This method is for exclusive usage of Studio tests");
        }
        return this.internalAddServerDefinition(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServerDefinition internalAddServerDefinition(IServerDefinition server) {
        IServerDefinition previous;
        Object object = this.lock;
        synchronized (object) {
            previous = this.servers.put(server.getId(), server);
            IPath pluginBaseDirectory = server.getPluginBaseDirectory();
            if (pluginBaseDirectory != null) {
                String baseDirectory = pluginBaseDirectory.toOSString();
                this.serverPathToServerMap.put(baseDirectory, server);
            }
            this.sorted = null;
        }
        return previous;
    }

    public Optional<IServerDefinition> getContainingServer(String jarPath) {
        Optional<IServerDefinition> containingServer = this.serverPathToServerMap.contains(jarPath) ? Optional.of(this.serverPathToServerMap.get(jarPath)) : Optional.empty();
        return containingServer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IServerDefinition removeServerDefinition(IServerDefinition server) {
        Object object = this.lock;
        synchronized (object) {
            IPath pluginBaseDirectory = server.getPluginBaseDirectory();
            if (pluginBaseDirectory != null) {
                String baseDirectory = pluginBaseDirectory.toOSString();
                this.serverPathToServerMap.put(baseDirectory, null);
            }
            this.sorted = null;
            return this.servers.remove(server.getId());
        }
    }

    public IServerDefinition getServerDefinition(String id) {
        return this.servers.get(id);
    }

    public boolean containsServerDefinition(String id) {
        return this.servers.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IServerDefinition> getServerDefinitions() {
        List<IServerDefinition> result = this.sorted;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.sorted;
                if (result == null) {
                    ArrayList<IServerDefinition> tempSorted = new ArrayList<IServerDefinition>(this.servers.values());
                    Collections.sort(tempSorted);
                    this.sorted = result = tempSorted;
                }
            }
        }
        return this.sorted;
    }

    private static class MuleServerManagerSingleton {
        private static final MuleServerManager instance = new MuleServerManager();

        private MuleServerManagerSingleton() {
        }
    }
}

