/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class MuleServerContext {
    private static final String MULE_LIB_PATCHES = "lib/patches";
    private static final String MULE_ARTIFACT_PATCHES = "lib/patches/mule-artifact-patches";
    private final String version;
    private final String versionWithSuffix;
    private final boolean isEnterprise;
    private Map<String, Object> properties;
    private final Path rootFolder;

    public MuleServerContext(Path rootFolder, String version, String versionWithSuffix, boolean isEnterprise) {
        this.rootFolder = rootFolder;
        this.version = version;
        this.versionWithSuffix = versionWithSuffix;
        this.isEnterprise = isEnterprise;
        this.properties = new HashMap<String, Object>();
    }

    public <T> Optional<T> getProperty(String key) {
        return Optional.ofNullable(this.properties.get(key));
    }

    public Path resolveAgainstRoot(String path) {
        return this.getRootFolder().resolve(path);
    }

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionWithSuffix() {
        return this.versionWithSuffix;
    }

    public boolean isEnterprise() {
        return this.isEnterprise;
    }

    public Path getRootFolder() {
        return this.rootFolder;
    }

    public Path getMulePatchesFolder() {
        return this.getRootFolder().resolve(MULE_LIB_PATCHES);
    }

    public Path getMuleArtifactPatchesFolder() {
        return this.getRootFolder().resolve(MULE_ARTIFACT_PATCHES);
    }
}

