/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import jakarta.inject.Inject;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerMatcher;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionChildElement;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.osgi.framework.Bundle;

@ExtensionPoint(extensionPointId="org.mule.tooling.core.log4j")
public class Log4jConfigurationExtension
implements Comparable<Log4jConfigurationExtension> {
    @Inject
    private Bundle bundle;
    @ExtensionChildElement(childElementsName="server", elementType=ServerMatcher.class, attributeName="matcher")
    private List<ServerMatcher> targetServers;
    @ExtensionAttribute
    private String mainFilePath;
    @ExtensionAttribute
    private String testFilePath;
    @ExtensionAttribute(optional=true)
    private Integer priority = 5;
    private static List<Log4jConfigurationExtension> extensions;

    public List<ServerMatcher> getTargetServers() {
        return this.targetServers;
    }

    public void setTargetServers(List<ServerMatcher> targetServers) {
        this.targetServers = targetServers;
    }

    public String getMainFilePath() {
        return this.mainFilePath;
    }

    public void setMainFilePath(String mainFilePath) {
        this.mainFilePath = mainFilePath;
    }

    public String getTestFilePath() {
        return this.testFilePath;
    }

    public void setTestFilePath(String testFilePath) {
        this.testFilePath = testFilePath;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public URL getMainFile() {
        return FileLocator.find((Bundle)this.bundle, (IPath)new Path(this.mainFilePath), null);
    }

    public String getMainFileName() {
        return new Path(this.mainFilePath).lastSegment();
    }

    public String getTestFileName() {
        return new Path(this.testFilePath).lastSegment();
    }

    public URL getTestFile() {
        return FileLocator.find((Bundle)this.bundle, (IPath)new Path(this.testFilePath), null);
    }

    public boolean matches(IServerDefinition definition) {
        for (ServerMatcher matcher : this.getTargetServers()) {
            if (!matcher.matches(definition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Log4jConfigurationExtension o) {
        return this.getPriority().compareTo(o.getPriority());
    }

    public static Optional<Log4jConfigurationExtension> getLog4jConfiguration(IServerDefinition definition) {
        ArrayList<Log4jConfigurationExtension> candidates = new ArrayList<Log4jConfigurationExtension>();
        for (Log4jConfigurationExtension extension : Log4jConfigurationExtension.getExtensions()) {
            if (!extension.matches(definition)) continue;
            candidates.add(extension);
        }
        if (candidates.isEmpty()) {
            return Optional.empty();
        }
        Collections.sort(candidates);
        return Optional.of((Log4jConfigurationExtension)candidates.get(0));
    }

    private static List<Log4jConfigurationExtension> getExtensions() {
        if (extensions == null) {
            extensions = IExtensionPointReader.create(Log4jConfigurationExtension.class).readAll();
        }
        return extensions;
    }
}

