/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.runtime.server.extensionpoint.FolderDefinition;
import org.mule.tooling.utils.extensionpoint.ExtensionChildElement;
import org.mule.tooling.utils.extensionpoint.ExtensionContext;

public class LibraryFolderDefinition
extends FolderDefinition {
    @ExtensionChildElement(childElementsName="classpathExclusion", attributeName="regex", elementType=String.class)
    private List<String> classpathExclusions;
    @ExtensionChildElement(childElementsName="classpathInclusion", attributeName="regex", elementType=String.class)
    private List<String> classpathInclusions;
    private List<IPath> jarPaths = new ArrayList<IPath>();

    public LibraryFolderDefinition() {
        this.setClasspathInclusions(new ArrayList<String>());
        this.setClasspathExclusions(new ArrayList<String>());
    }

    @Override
    public void initialize(ExtensionContext extensionContext) {
        super.initialize(extensionContext);
        String folderPath = this.getPath();
        Enumeration paths = extensionContext.getBundle().getEntryPaths(folderPath);
        if (paths != null) {
            while (paths.hasMoreElements()) {
                String simplePath = (String)paths.nextElement();
                File jarPath = new File(extensionContext.getBundleRoot(), simplePath);
                String pathUrl = jarPath.getPath();
                IPath path = Path.fromOSString((String)pathUrl).makeAbsolute();
                this.addJarPath(path);
            }
        }
    }

    public void addJarPath(IPath jarPath) {
        this.jarPaths.add(jarPath);
    }

    public List<IPath> getJarPaths() {
        return this.jarPaths;
    }

    public List<String> getClasspathExclusions() {
        return this.classpathExclusions;
    }

    public List<String> getClasspathInclusions() {
        return this.classpathInclusions;
    }

    public void setClasspathExclusions(List<String> classpathExclusions) {
        this.classpathExclusions = classpathExclusions;
    }

    public void setClasspathInclusions(List<String> classpathInclusions) {
        this.classpathInclusions = classpathInclusions;
    }

    public List<IPath> getClasspathContainerPaths() {
        if (this.isIncludeInContainer()) {
            ArrayList<IPath> classpathContainerPaths = new ArrayList<IPath>(this.jarPaths.size());
            for (IPath path : this.jarPaths) {
                if (!this.isValidJavaLibrary(path) || !this.isIncludedInClasspath(path)) continue;
                classpathContainerPaths.add(path);
            }
            return classpathContainerPaths;
        }
        return Collections.emptyList();
    }

    private boolean isIncludedInClasspath(IPath path) {
        boolean isIncluded = true;
        if (!this.getClasspathInclusions().isEmpty()) {
            isIncluded = false;
            for (String inclusion : this.getClasspathInclusions()) {
                isIncluded |= path.lastSegment().matches(inclusion);
            }
        }
        if (!this.getClasspathExclusions().isEmpty()) {
            for (String exclusion : this.getClasspathExclusions()) {
                isIncluded &= !path.lastSegment().matches(exclusion);
            }
        }
        return isIncluded;
    }

    private boolean isValidJavaLibrary(IPath path) {
        String fileExtension = path.getFileExtension();
        return fileExtension != null && (fileExtension.equals("zip") || fileExtension.equals("jar")) || path.toFile().isDirectory();
    }

    public String toString() {
        return "Lib Folder -> " + this.getLabel();
    }
}

