/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.io.File;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Namespace;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.runtime.server.BaseAbstractSchemaLocationLookup;
import org.mule.tooling.core.runtime.server.CurrentVersionInMuleNamespaceEnforcer;
import org.mule.tooling.core.tooling.ToolingCachePathUtils;

public class ExternalContributionSchemaLookup
extends BaseAbstractSchemaLocationLookup {
    private final List<ExternalContributionMuleModule> externalModules;

    public ExternalContributionSchemaLookup(List<ExternalContributionMuleModule> externalModules) {
        this.externalModules = externalModules;
        ArrayList<CallSite> schemalocationTransformationMessages = new ArrayList<CallSite>();
        CurrentVersionInMuleNamespaceEnforcer currentVersionInMuleNamespaceEnforcer = new CurrentVersionInMuleNamespaceEnforcer();
        for (ExternalContributionMuleModule externalModule : externalModules) {
            Namespace moduleNamespace = Namespace.get((String)externalModule.getContributionNamespacePrefix(), (String)externalModule.getContributionNamespace());
            String contributionNamespaceFile = externalModule.getContributionNamespaceFile();
            String transformedSchemaLocation = currentVersionInMuleNamespaceEnforcer.getSchemaLocation(contributionNamespaceFile);
            if (!transformedSchemaLocation.equals(contributionNamespaceFile)) {
                schemalocationTransformationMessages.add((CallSite)((Object)("Forcing the usage of 'current' in the schemaLocation of " + this.getLabel(externalModule) + ". Original schemaLocation is: " + contributionNamespaceFile + ". New schemaLocation is: " + transformedSchemaLocation)));
            }
            this.addSchemaLocation(moduleNamespace, transformedSchemaLocation);
        }
        if (!schemalocationTransformationMessages.isEmpty()) {
            String concatenatedMessage = StringUtils.join((Object[])schemalocationTransformationMessages.toArray(), (String)"\n");
            MuleCorePlugin.logInfo(concatenatedMessage);
        }
    }

    private String getLabel(ExternalContributionMuleModule extModule) {
        String label = extModule.getName() + " [version " + extModule.getVersion();
        String minimumVersion = extModule.getMinimumVersion();
        if (StringUtils.isNotEmpty((String)minimumVersion)) {
            label = label + ", ESB version " + minimumVersion + "+";
        }
        return label + "]";
    }

    @Override
    public String getSchemaUrl(String muleConfigUri, String schema, String schemaLocationUri) {
        for (ExternalContributionMuleModule externalContributionMuleModule : this.externalModules) {
            File schemaFile;
            if (!externalContributionMuleModule.getContributionNamespace().equals(schema) && !externalContributionMuleModule.getContributionNamespaceFile().equals(schemaLocationUri) || (schemaFile = this.getSchemaFileFromExternalContribution(externalContributionMuleModule)) == null || !schemaFile.exists()) continue;
            try {
                return schemaFile.toURI().toURL().toExternalForm();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    private File getSchemaFileFromExternalContribution(ExternalContributionMuleModule extModule) {
        Path baseDir = ToolingCachePathUtils.getEditorsCachePath().toFile().toPath();
        String id = extModule.getId();
        MavenDependency pluginDependency = MavenUtils.getPluginDependency(id);
        String groupId = pluginDependency.getGroupId();
        String[] split = groupId.split("\\.");
        List<String> groupIdParts = Arrays.asList(split);
        for (String part : groupIdParts) {
            baseDir = baseDir.resolve(part);
        }
        Path root = baseDir.resolve(pluginDependency.getArtifactId()).resolve(pluginDependency.getVersion());
        String schemaFile = extModule.getContributionNamespaceFile();
        String getSchemaFileName = schemaFile.substring(schemaFile.lastIndexOf("/") + 1);
        Path schemaPath = root.resolve(getSchemaFileName);
        return schemaPath.toFile();
    }
}

