/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CurrentVersionInMuleNamespaceEnforcer {
    private static final String CURRENT = "current";
    private static final String ALPHANUMERIC_WITH_HYPHENS_AND_DOTS = "[a-zA-Z0-9-_\\\\.]+";
    private static final Pattern HAS_CURRENT_REGEX = Pattern.compile("http://www.mulesoft.org/schema/mule/(?:ee/)?[a-zA-Z0-9-_\\\\.]+/current/mule-[a-zA-Z0-9-_\\\\.]+\\.xsd");
    private static final Pattern CAPTURE_VERSION_REGEX = Pattern.compile("http://www.mulesoft.org/schema/mule/(?:ee/)?[a-zA-Z0-9-_\\\\.]+/([a-zA-Z0-9-_\\\\.]+)/mule-[a-zA-Z0-9-_\\\\.]+\\.xsd");
    private static final int VERSION_GROUP_INDEX = 1;

    public String getSchemaLocation(String contributionNamespaceFile) {
        if (contributionNamespaceFile == null) {
            return null;
        }
        Object transformedNamespace = null;
        Matcher hasCurrentMatcher = HAS_CURRENT_REGEX.matcher(contributionNamespaceFile);
        if (hasCurrentMatcher.matches()) {
            transformedNamespace = contributionNamespaceFile;
        } else {
            Matcher captureVersionMatcher = CAPTURE_VERSION_REGEX.matcher(contributionNamespaceFile);
            if (captureVersionMatcher.matches()) {
                int versionStartIndex = captureVersionMatcher.start(1);
                int versionEndIndex = captureVersionMatcher.end(1);
                transformedNamespace = contributionNamespaceFile.substring(0, versionStartIndex) + CURRENT + contributionNamespaceFile.substring(versionEndIndex);
            } else {
                transformedNamespace = contributionNamespaceFile;
            }
        }
        return transformedNamespace;
    }
}

