/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.runtime.server.ArtifactInformationItem;

public class ArtifactsInformationProvider {
    private static final String ELEMENT_NAME_ARTIFACT = "artifact";
    private static final String SERVER_ARTIFACTS_EXT_POINT_ID = "org.mule.tooling.server.artifacts";
    private final String serverId;
    private final Set<ArtifactInformationItem> artifacts;

    public static ArtifactsInformationProvider forServerId(String serverId) {
        if (serverId == null) {
            throw new IllegalArgumentException("param serverId cannot be null");
        }
        IConfigurationElement[] configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(SERVER_ARTIFACTS_EXT_POINT_ID);
        HashSet<ArtifactInformationItem> artifacts = new HashSet<ArtifactInformationItem>();
        IConfigurationElement[] iConfigurationElementArray = configurationElements;
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            artifacts.addAll(ArtifactsInformationProvider.getArtifactItems(configurationElement));
            ++n2;
        }
        return new ArtifactsInformationProvider(serverId, artifacts);
    }

    private static List<ArtifactInformationItem> getArtifactItems(IConfigurationElement targetConfigurationElement) {
        IConfigurationElement[] artifacts;
        ArrayList<ArtifactInformationItem> artifactsList = new ArrayList<ArtifactInformationItem>();
        IConfigurationElement[] iConfigurationElementArray = artifacts = targetConfigurationElement.getChildren(ELEMENT_NAME_ARTIFACT);
        int n = artifacts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement artifact = iConfigurationElementArray[n2];
            String groupId = artifact.getAttribute("groupId");
            String artifactId = artifact.getAttribute("artifactId");
            String version = artifact.getAttribute("version");
            String fileName = artifact.getAttribute("fileName");
            ArtifactInformationItem artifactInformationItem = new ArtifactInformationItem(groupId, artifactId, version, fileName);
            artifactsList.add(artifactInformationItem);
            ++n2;
        }
        return artifactsList;
    }

    public ArtifactsInformationProvider(String serverId, Set<ArtifactInformationItem> artifacts) {
        this.serverId = serverId;
        this.artifacts = artifacts;
    }

    public ArtifactInformationItem getItemForFileName(String name) {
        for (ArtifactInformationItem item : this.artifacts) {
            if (!item.getFileName().equals(name)) continue;
            return item;
        }
        return null;
    }

    public String toString() {
        return "ArtifactsInformationProvider [serverId=" + this.serverId + ", artifactsList=" + String.valueOf(this.artifacts) + "]";
    }
}

