/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.server;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.dom4j.Namespace;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.runtime.server.BaseAbstractSchemaLocationLookup;
import org.osgi.framework.Bundle;

public abstract class AbstractSchemaLocationLookup
extends BaseAbstractSchemaLocationLookup {
    private Properties springSchemas;
    private Properties relativePathToTargetNamespaceIndex;
    private Properties targetNamespaceToRelativePathIndex;
    protected Map<Namespace, String> SCHEMA_LOCATIONS;
    private Bundle bundle;

    public AbstractSchemaLocationLookup(Bundle bundle) {
        this.bundle = bundle;
        this.loadSpringSchemas();
        this.loadTargetNamespaceIndexes();
        this.SCHEMA_LOCATIONS = this.schemaLocations;
    }

    protected Properties getRelativePathToTargetNamespaceIndex() {
        return this.relativePathToTargetNamespaceIndex;
    }

    protected Properties getTargetNamespaceToRelativePathIndex() {
        return this.targetNamespaceToRelativePathIndex;
    }

    protected Properties getSpringSchemas() {
        return this.springSchemas;
    }

    protected void loadTargetNamespaceIndexes() {
        block7: {
            InputStream targetNamespacesStream = null;
            this.relativePathToTargetNamespaceIndex = new Properties();
            this.targetNamespaceToRelativePathIndex = new Properties();
            try {
                try {
                    URL targetNamespaceIndexUrl = this.getURL("schemas", "targetNamespace.index");
                    if (targetNamespaceIndexUrl != null) {
                        targetNamespacesStream = targetNamespaceIndexUrl.openStream();
                        this.relativePathToTargetNamespaceIndex.load(targetNamespacesStream);
                    }
                    for (Object key : this.relativePathToTargetNamespaceIndex.keySet()) {
                        this.targetNamespaceToRelativePathIndex.put(this.relativePathToTargetNamespaceIndex.get(key), key);
                    }
                }
                catch (IOException e) {
                    MuleCorePlugin.logError(e.getMessage(), e);
                    IOUtils.closeQuietly(targetNamespacesStream);
                    break block7;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(targetNamespacesStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)targetNamespacesStream);
        }
    }

    protected void loadSpringSchemas() {
        InputStream springSchemasStream = null;
        this.springSchemas = new Properties();
        try {
            try {
                URL springSchemasUrl = this.getURL("schemas", "spring.schemas");
                if (springSchemasUrl != null) {
                    springSchemasStream = springSchemasUrl.openStream();
                    this.springSchemas.load(springSchemasStream);
                }
            }
            catch (IOException e) {
                MuleCorePlugin.logError(e.getMessage(), e);
                IOUtils.closeQuietly(springSchemasStream);
            }
        }
        finally {
            IOUtils.closeQuietly(springSchemasStream);
        }
    }

    @Override
    public String getSchemaUrl(String muleConfigUri, String schema, String schemaLocationUri) {
        String url = null;
        if (schemaLocationUri != null) {
            try {
                url = this.searchInSpringSchemasIndex(schemaLocationUri);
                if (url == null) {
                    url = this.searchInTargetNamespaceIndexes(schema, schemaLocationUri);
                }
            }
            catch (IOException e) {
                MuleCorePlugin.logError(e.getMessage(), e);
            }
        }
        return url;
    }

    private String searchInSpringSchemasIndex(String schemaLocationUri) throws IOException {
        String url = null;
        Properties springSchemas = this.getSpringSchemas();
        String schemaRelativePath = springSchemas.getProperty(schemaLocationUri);
        if (schemaRelativePath != null) {
            url = this.getURLString("schemas", schemaRelativePath);
        }
        return url;
    }

    private String searchInTargetNamespaceIndexes(String schema, String schemaLocationUri) throws IOException {
        String url = null;
        Properties targetNamespaceToRelativePathIndex = this.getTargetNamespaceToRelativePathIndex();
        if (schema != null && targetNamespaceToRelativePathIndex.containsKey(schema)) {
            String localFilePath = targetNamespaceToRelativePathIndex.getProperty(schema);
            url = this.getURLString("schemas", localFilePath);
        } else {
            url = this.searchForFilesValidatingTargetNamespace(schemaLocationUri);
        }
        return url;
    }

    private String searchForFilesValidatingTargetNamespace(String schemaLocationUri) throws IOException {
        String url = null;
        Properties relativePathToTargetNamespaceIndex = this.getRelativePathToTargetNamespaceIndex();
        String fileName = schemaLocationUri.substring(schemaLocationUri.lastIndexOf(47) + 1);
        URL schemasUrl = FileLocator.find((Bundle)this.getOsgiBundle(), (IPath)new Path("schemas"), null);
        if (schemasUrl != null) {
            File schemasDirectory = this.toFile(schemasUrl);
            for (File localSchemaFile : this.getFileOccurrencesInDirectory(schemasDirectory, fileName)) {
                String pathRelativeToSchemas = this.getPathRelativeToSchemas(localSchemaFile, schemasDirectory);
                String namespace = relativePathToTargetNamespaceIndex.getProperty(pathRelativeToSchemas);
                if (namespace == null || !schemaLocationUri.startsWith(namespace)) continue;
                url = this.getURLString("schemas", pathRelativeToSchemas);
            }
        }
        return url;
    }

    private String getPathRelativeToSchemas(File file, File schemasFolder) {
        String schemasPath = schemasFolder.getAbsolutePath();
        String filePath = file.getAbsolutePath();
        if (filePath.startsWith(schemasPath)) {
            return filePath.substring(schemasPath.length() + 1);
        }
        return null;
    }

    private List<File> getFileOccurrencesInDirectory(File directory, String fileName) {
        ArrayList<File> foundFiles = new ArrayList<File>();
        this.collectFileOccurrences(directory, fileName, foundFiles);
        return foundFiles;
    }

    private void collectFileOccurrences(File directory, String fileName, List<File> foundFiles) {
        if (directory == null || !directory.exists()) {
            return;
        }
        if (directory.isDirectory()) {
            File[] files;
            File[] fileArray = files = directory.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.collectFileOccurrences(file, fileName, foundFiles);
                ++n2;
            }
        } else {
            File file = directory;
            if (file.getName().equals(fileName)) {
                foundFiles.add(file);
            }
        }
    }

    private File toFile(URL url) throws IOException {
        File f;
        try {
            f = new File(FileLocator.toFileURL((URL)url).toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            f = new File(url.getPath());
        }
        return f;
    }

    protected String getURLString(String prefix, String schemaFileName) throws IOException {
        URL pluginURL = this.getURL(prefix, schemaFileName);
        if (pluginURL != null) {
            return pluginURL.toExternalForm();
        }
        return null;
    }

    protected URL getURL(String prefix, String schemaFileName) throws IOException {
        URL pluginURL = FileLocator.find((Bundle)this.getOsgiBundle(), (IPath)new Path(prefix + "/" + schemaFileName), null);
        if (pluginURL != null) {
            return FileLocator.toFileURL((URL)pluginURL);
        }
        return null;
    }

    protected Bundle getOsgiBundle() {
        return this.bundle;
    }
}

