/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.building.ModelBuildingException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.runtime.internal.BaseInstallationContributionExtension;
import org.mule.tooling.core.runtime.server.InstallationContribution;
import org.mule.tooling.core.runtime.server.MuleServerContext;
import org.mule.tooling.core.utils.VersionComparator;
import org.mule.tooling.osgi.services.ServicesRegistry;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspector;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspectorService;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

@ExtensionPoint(extensionPointId="org.mule.tooling.core.installationContribution", elementName="overrideDebugger")
public class OverrideDebuggerInServer
extends BaseInstallationContributionExtension
implements InstallationContribution {
    private static final String DEBUGGER = "debugger";
    private static final String SERVER_PLUGINS_STAGING = "server-plugins-staging";
    @ExtensionAttribute
    private String target;
    @ExtensionAttribute
    private String sourceFile;
    @ExtensionAttribute
    private String bundledFileVersion;
    private String currentDebuggerVersion;
    private File currentDebugger;

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getDebuggerVersion() {
        return this.currentDebuggerVersion;
    }

    public String getBundledFileVersion() {
        return this.bundledFileVersion;
    }

    public void setBundledFileVersion(String bundledFileVersion) {
        this.bundledFileVersion = bundledFileVersion;
    }

    @Override
    public boolean isSatisfied(MuleServerContext context) {
        File defaultDebugger = this.getDefaultDebugger(context);
        try {
            return !this.shouldOverride(defaultDebugger);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public boolean installContribution(MuleServerContext context) {
        File defaultDebugger = this.getDefaultDebugger(context);
        try {
            this.doOverride(defaultDebugger);
        }
        catch (IOException e) {
            MuleCorePlugin.logError("There was a problem installing the debugger server", e);
            return false;
        }
        return true;
    }

    private File getDefaultDebugger(MuleServerContext context) {
        java.nio.file.Path resolve = context.resolveAgainstRoot(this.target);
        File targetFile = resolve.toFile();
        if (Files.isDirectory(resolve, new LinkOption[0])) {
            IPath targetFilePath = Path.fromOSString((String)this.getSourceFile());
            File source = targetFilePath.toFile();
            targetFile = new File(targetFile, source.getName());
        }
        return targetFile;
    }

    private boolean shouldOverride(File defaultDebugger) throws IOException {
        File[] files = defaultDebugger.getParentFile().listFiles((d, name) -> name.contains(DEBUGGER));
        if (files != null && files.length > 0) {
            this.currentDebugger = files[0];
            this.setCurrentDebuggerVersion(this.currentDebugger);
        }
        VersionComparator versionComparator = VersionComparator.forVersion(this.bundledFileVersion);
        return StringUtils.isEmpty((CharSequence)this.currentDebuggerVersion) || versionComparator.compareVersionTo(this.currentDebuggerVersion) > 0;
    }

    private void doOverride(File defaultDebugger) throws IOException {
        this.currentDebuggerVersion = this.bundledFileVersion;
        if (this.currentDebugger != null) {
            this.moveDebuggerToStaging(this.currentDebugger);
        }
        this.copyFile(defaultDebugger.getParentFile());
    }

    private void copyFile(File file) throws IOException {
        File targetFile = file;
        IPath targetFilePath = Path.fromOSString((String)this.getSourceFile());
        if (file.isDirectory()) {
            targetFile = new File(file, targetFilePath.segment(targetFilePath.segmentCount() - 1));
        }
        targetFile.getParentFile().mkdirs();
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream stream = FileLocator.openStream((Bundle)this.getBundle(), (IPath)targetFilePath, (boolean)false);){
            FileUtils.copyInputStreamToFile((InputStream)stream, (File)targetFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void setCurrentDebuggerVersion(File debugger) throws IOException {
        if (debugger.isDirectory()) {
            this.setDebuggerVersionFromDirectory(debugger);
        } else {
            this.setDebuggerVersionFromJar(debugger);
        }
    }

    private void setDebuggerVersionFromDirectory(File debuggerDirectory) {
        File debuggerMavenFolder = new File(debuggerDirectory, "META-INF/maven");
        try {
            if (debuggerMavenFolder.exists()) {
                Files.walkFileTree(debuggerMavenFolder.toPath(), (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                    @Override
                    public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                        try {
                            OverrideDebuggerInServer.this.currentDebuggerVersion = MavenCore.getMavenModelReader().readModel(file.toFile(), Collections.emptyList(), new Properties()).getEffectiveModel().getVersion();
                        }
                        catch (ModelBuildingException e) {
                            MuleCorePlugin.logError("There was a problem retrieving the debugger version", e);
                        }
                        return FileVisitResult.TERMINATE;
                    }
                });
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError("There was a problem retrieving the debugger version", e);
        }
    }

    private void setDebuggerVersionFromJar(File debuggerJar) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JarFile jarFile = new JarFile(debuggerJar);){
                MavenJarFileInspectorService mavenJarInspectorService = ServicesRegistry.get().getMavenJarInspectorService();
                MavenJarFileInspector inspector = mavenJarInspectorService.getInspector(jarFile);
                this.currentDebuggerVersion = inspector.getVersion();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logError("There was a problem retrieving the debugger version", e);
        }
    }

    private boolean moveDebuggerToStaging(File debugger) {
        File muleFolder = debugger.getParentFile().getParentFile();
        try {
            FileUtils.moveToDirectory((File)debugger, (File)new File(muleFolder, SERVER_PLUGINS_STAGING), (boolean)true);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private Optional<File> getDebuggerFromStaging(File muleFolder) {
        File staging = new File(muleFolder, SERVER_PLUGINS_STAGING);
        File[] files = staging.listFiles((d, name) -> name.contains(DEBUGGER));
        if (files != null && files.length > 0) {
            return Optional.of(files[0]);
        }
        return Optional.empty();
    }

    @Override
    public boolean uninstallContribution(MuleServerContext context) {
        File serverPlugins = context.resolveAgainstRoot(this.target).toFile();
        Optional<File> stagedDebugger = this.getDebuggerFromStaging(serverPlugins.getParentFile());
        if (!stagedDebugger.isPresent()) {
            return true;
        }
        try {
            FileUtils.moveToDirectory((File)stagedDebugger.get(), (File)serverPlugins, (boolean)true);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public InstallationContribution getContribution() {
        return this;
    }

    @Override
    public String toString() {
        return "OverrideDebuggerInServer [targetFile=" + this.target + ", sourceFile=" + this.sourceFile + "]";
    }

    @Override
    public boolean applies(MuleServerContext context) {
        return this.getTargetRuntime().matches(Version.parseVersion((String)context.getVersion()), context.isEnterprise());
    }
}

