/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.mule.tooling.core.runtime.MuleClasspathContainer;

public class MuleContainersStatusModel {
    private Map<IPath, MuleClasspathContainer> pathToContainerMap = new HashMap<IPath, MuleClasspathContainer>();
    private Map<MuleClasspathContainer, Set<IJavaProject>> containerToProjectsMap = new HashMap<MuleClasspathContainer, Set<IJavaProject>>();

    public static MuleContainersStatusModel instance() {
        return Singleton.instance;
    }

    public MuleClasspathContainer bind(IPath containerPath, MuleClasspathContainer newContainer, Collection<IJavaProject> projects) {
        MuleClasspathContainer targetContainer = this.bindContainerIfAbsent(containerPath, newContainer);
        this.addAllToContainerToProjectsMap(targetContainer, projects);
        return targetContainer;
    }

    public MuleClasspathContainer bind(IPath containerPath, MuleClasspathContainer newContainer, IJavaProject project) {
        MuleClasspathContainer targetContainer = this.bindContainerIfAbsent(containerPath, newContainer);
        this.addToContainerToProjectsMap(targetContainer, project);
        return targetContainer;
    }

    private MuleClasspathContainer bindContainerIfAbsent(IPath containerPath, MuleClasspathContainer newContainer) {
        if (!this.pathToContainerMap.containsKey(containerPath)) {
            this.pathToContainerMap.put(containerPath, newContainer);
        }
        MuleClasspathContainer targetContainer = this.pathToContainerMap.get(containerPath);
        return targetContainer;
    }

    public Collection<IJavaProject> reassign(IPath containerPath, MuleClasspathContainer newContainer) {
        MuleClasspathContainer previousValue = this.pathToContainerMap.put(containerPath, newContainer);
        Collection<IJavaProject> projects = this.removeFromContainerToProjectsMap(previousValue);
        this.addAllToContainerToProjectsMap(newContainer, projects);
        return projects;
    }

    private void addToContainerToProjectsMap(MuleClasspathContainer targetContainer, IJavaProject project) {
        if (!this.containerToProjectsMap.containsKey(targetContainer)) {
            this.containerToProjectsMap.put(targetContainer, new HashSet());
        }
        this.containerToProjectsMap.get(targetContainer).add(project);
    }

    private void addAllToContainerToProjectsMap(MuleClasspathContainer newContainer, Collection<IJavaProject> projects) {
        if (!this.containerToProjectsMap.containsKey(newContainer)) {
            this.containerToProjectsMap.put(newContainer, new HashSet());
        }
        this.containerToProjectsMap.get(newContainer).addAll(projects);
    }

    private Collection<IJavaProject> removeFromContainerToProjectsMap(MuleClasspathContainer previousValue) {
        return this.containerToProjectsMap.remove(previousValue);
    }

    public MuleClasspathContainer getClasspathContainer(String runtimeId) {
        IPath containerPath = MuleClasspathContainer.buildContainerPath(runtimeId);
        return this.pathToContainerMap.get(containerPath);
    }

    public Collection<IJavaProject> getBoundProjects(MuleClasspathContainer classpathContainer) {
        return this.containerToProjectsMap.get(classpathContainer);
    }

    private static class Singleton {
        private static final MuleContainersStatusModel instance = new MuleContainersStatusModel();

        private Singleton() {
        }
    }
}

