/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.runtime.MuleClasspathContainer;
import org.mule.tooling.core.runtime.server.ClasspathElementDefinition;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.LibraryFolderDefinition;
import org.mule.tooling.core.utils.ClasspathEntryUtils;

public class DefaultMuleClasspathContainer
extends MuleClasspathContainer {
    private final Object lock = new Object();
    private final IPath path;
    private final IServerDefinition serverDefinition;
    private volatile IClasspathEntry[] entries;

    public DefaultMuleClasspathContainer(IServerDefinition serverDefinition) {
        this.serverDefinition = serverDefinition;
        this.path = DefaultMuleClasspathContainer.buildContainerPath(serverDefinition.getId());
    }

    public DefaultMuleClasspathContainer(IServerDefinition serverDefinition, IClasspathEntry[] classpathEntries) {
        this(serverDefinition);
        this.entries = classpathEntries;
        this.initializeDefaultEntriesAttributes();
    }

    private void initializeDefaultEntriesAttributes() {
        int i = 0;
        while (i < this.entries.length) {
            IClasspathEntry newEntry = this.getEntryWithSourceAttachmentIfMissing(this.entries[i]);
            this.entries[i] = newEntry = this.getEntryWithAccessRulesIfMissing(newEntry);
            ++i;
        }
    }

    private IClasspathEntry getEntryWithAccessRulesIfMissing(IClasspathEntry entry) {
        IClasspathEntry newEntry = entry;
        if (entry.getAccessRules() == null || entry.getAccessRules().length == 0) {
            newEntry = ClasspathEntryUtils.newLibraryEntryWithRestrictAccess(entry.getPath(), entry.getSourceAttachmentPath());
        }
        return newEntry;
    }

    private IClasspathEntry getEntryWithSourceAttachmentIfMissing(IClasspathEntry entry) {
        IPath sourceAttachment;
        IClasspathEntry newEntry = entry;
        if (entry.getSourceAttachmentPath() == null && (sourceAttachment = ProjectClasspathUtils.getSourceAttachment(this.getServerDefinition(), entry.getPath())) != null) {
            newEntry = ClasspathEntryUtils.newLibraryEntryWithRestrictAccess(entry.getPath(), sourceAttachment);
        }
        return newEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IClasspathEntry[] getClasspathEntries() {
        IClasspathEntry[] result = this.entries;
        if (result == null) {
            Object object = this.lock;
            synchronized (object) {
                result = this.entries;
                if (result == null) {
                    result = this.entries = this.initializeEntries();
                }
            }
        }
        return result;
    }

    private IClasspathEntry[] initializeEntries() {
        IServerDefinition server = this.getServerDefinition();
        ArrayList<IClasspathEntry> matches = new ArrayList<IClasspathEntry>();
        this.collectEntriesFromLibraryFolders(server, matches);
        this.collectEntriesFromClasspathElements(server, matches);
        return matches.toArray(new IClasspathEntry[0]);
    }

    private void collectEntriesFromClasspathElements(IServerDefinition server, List<IClasspathEntry> matches) {
        List<ClasspathElementDefinition> classpathElements = server.getClasspathElements();
        for (ClasspathElementDefinition classpathElementDefinition : classpathElements) {
            Path entryPath = new Path(classpathElementDefinition.getAbsolutePath());
            IClasspathEntry newLibraryEntry = this.createEntry(server, (IPath)entryPath);
            matches.add(newLibraryEntry);
        }
    }

    private void collectEntriesFromLibraryFolders(IServerDefinition server, List<IClasspathEntry> matches) {
        List<LibraryFolderDefinition> libs = server.getLibraryFolders();
        for (LibraryFolderDefinition lib : libs) {
            List<IPath> paths = lib.getClasspathContainerPaths();
            for (IPath path : paths) {
                IClasspathEntry entry = this.createEntry(server, path);
                matches.add(entry);
            }
        }
    }

    private IClasspathEntry createEntry(IServerDefinition server, IPath path) {
        IPath sourceAttachmentPath = ProjectClasspathUtils.getSourceAttachment(server, path);
        return ClasspathEntryUtils.newLibraryEntryWithRestrictAccess(path, sourceAttachmentPath);
    }

    public String getDescription() {
        IServerDefinition server = this.getServerDefinition();
        if (server != null) {
            return server.getLabel();
        }
        return "Mule Runtime";
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    @Override
    public IServerDefinition getServerDefinition() {
        return this.serverDefinition;
    }

    public String toString() {
        return "MuleClasspathContainer [path=" + String.valueOf(this.path) + ", serverDefinition=" + String.valueOf(this.serverDefinition) + "]";
    }
}

