/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.utils.ClasspathEntryUtils;

public class ClasspathContainerCache<T> {
    private static final String CLASSPATH_CACHE_IN_MEMORY_SIZE = "org.mule.tooling.classpath.cache.inMemorySize";
    private static final int IN_MEMORY_CACHE_SIZE = Integer.parseInt(System.getProperty("org.mule.tooling.classpath.cache.inMemorySize", "30"));
    private Function<T, java.nio.file.Path> keyToPath;
    private final Gson serializer = new GsonBuilder().create();
    private Map<T, List<IClasspathEntry>> cachedEntries = new LinkedHashMap<T, List<IClasspathEntry>>(IN_MEMORY_CACHE_SIZE){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<T, List<IClasspathEntry>> eldest) {
            return this.size() > IN_MEMORY_CACHE_SIZE;
        }
    };

    public ClasspathContainerCache(Function<T, java.nio.file.Path> keyToPath) {
        this.keyToPath = keyToPath;
    }

    public Optional<List<IClasspathEntry>> get(T cacheKey) {
        if (this.cachedEntries.containsKey(cacheKey)) {
            return Optional.of(this.cachedEntries.get(cacheKey));
        }
        java.nio.file.Path associatedFileFrom = this.keyToPath.apply(cacheKey);
        if (associatedFileFrom.toFile().exists()) {
            try {
                Type arrayEntriesType = new TypeToken<ArrayList<SimpleClasspathEntry>>(){}.getType();
                List storedEntries = (List)this.serializer.fromJson(new String(Files.readAllBytes(associatedFileFrom)), arrayEntriesType);
                List entries = storedEntries.stream().map(entry -> {
                    Path sourceAttachmentPath;
                    Path entryPath = new Path(entry.getPath());
                    Path path = sourceAttachmentPath = StringUtils.isEmpty((CharSequence)entry.getSourceAttachment()) ? null : new Path(entry.getSourceAttachment());
                    if (entry.isRestricted()) {
                        return ClasspathEntryUtils.newLibraryEntryWithRestrictAccess((IPath)entryPath, (IPath)sourceAttachmentPath);
                    }
                    return ClasspathEntryUtils.newLibraryEntryWithSourceAttachment((IPath)entryPath, (IPath)sourceAttachmentPath);
                }).collect(Collectors.toList());
                this.cachedEntries.put(cacheKey, entries);
                for (IClasspathEntry entry2 : entries) {
                    if (entry2.getPath().toFile().exists()) continue;
                    associatedFileFrom.toFile().delete();
                    return Optional.empty();
                }
                return Optional.of(entries);
            }
            catch (Exception ex) {
                MuleCorePlugin.debugTracer().trace("/debug/classpath-cache", "Unexpected error retrieving cached classpath", (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    public void storeEntries(T cacheKey, List<IClasspathEntry> entries) {
        File classloaderFile = this.keyToPath.apply(cacheKey).toFile();
        this.cachedEntries.put(cacheKey, entries);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileOutputStream cachedClasspath = new FileOutputStream(classloaderFile);){
                cachedClasspath.write(this.serializer.toJson(entries.stream().map(entry -> {
                    String absolutePath = entry.getPath().toFile().getAbsolutePath();
                    IPath sourceAttachmentPath = entry.getSourceAttachmentPath();
                    String sourcePath = sourceAttachmentPath != null ? sourceAttachmentPath.toFile().getAbsolutePath() : null;
                    boolean restrictAccess = entry.getAccessRules().length > 0;
                    return new SimpleClasspathEntry(absolutePath, sourcePath, restrictAccess);
                }).collect(Collectors.toList())).getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            MuleCorePlugin.debugTracer().trace("/debug/classpath-cache", "Unexpected error storing classpath entries", (Throwable)ex);
        }
    }

    private static final class SimpleClasspathEntry {
        private String path;
        private String sourceAttachment;
        private boolean restricted;

        public SimpleClasspathEntry(String path, String sourceAttachment, boolean restricted) {
            this.path = path;
            this.sourceAttachment = sourceAttachment;
            this.restricted = restricted;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getSourceAttachment() {
            return this.sourceAttachment;
        }

        public void setSourceAttachment(String sourceAttachment) {
            this.sourceAttachment = sourceAttachment;
        }

        public boolean isRestricted() {
            return this.restricted;
        }

        public void setRestricted(boolean restricted) {
            this.restricted = restricted;
        }
    }
}

