/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime.internal;

import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.mule.tooling.core.module.internal.runner.ArtifactResolvingRunner;
import org.mule.tooling.core.runtime.Scheduler;
import org.mule.tooling.core.utils.JobUtils;

public class ArtifactResolvingRunnerJobScheduler
implements Scheduler {
    private static final JobGroup SCHEDULER_GROUP = JobUtils.createJobGroup("Scheduler", ArtifactResolvingRunner.RESOLVER_THREAD_COUNT);

    public static Scheduler getInstance() {
        return JobSchedulerHolder.INSTANCE;
    }

    @Override
    public JobGroup getSchedulerGroup() {
        return SCHEDULER_GROUP;
    }

    private ArtifactResolvingRunnerJobScheduler() {
    }

    @Override
    public void schedule(String jobName, ICoreRunnable runnable) {
        this.schedule(jobName, runnable, 0L);
    }

    @Override
    public void schedule(String jobName, ICoreRunnable runnable, long delayInMilliseconds) {
        Job job = Job.create((String)jobName, (ICoreRunnable)runnable);
        job.setJobGroup(SCHEDULER_GROUP);
        job.setSystem(true);
        job.setPriority(20);
        job.schedule(delayInMilliseconds);
    }

    private static final class JobSchedulerHolder {
        private static final ArtifactResolvingRunnerJobScheduler INSTANCE = new ArtifactResolvingRunnerJobScheduler();

        private JobSchedulerHolder() {
        }
    }
}

