/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.ISourceAttachmentEventListener;
import org.mule.tooling.core.runtime.ClasspathContainerConfigurer;
import org.mule.tooling.core.runtime.MuleClasspathContainer;
import org.mule.tooling.core.runtime.internal.ClasspathContainerCache;
import org.mule.tooling.core.runtime.internal.ContainerSuggestion;
import org.mule.tooling.core.runtime.internal.DefaultMuleClasspathContainer;
import org.mule.tooling.core.runtime.internal.MuleContainersStatusModel;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.MuleServerManager;
import org.mule.tooling.core.runtime.sources.ClasspathEntryKind;
import org.mule.tooling.core.runtime.sources.SourceAttachmentPreferences;
import org.mule.tooling.core.tooling.ToolingCachePathUtils;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class MuleClasspathInitializer
extends ClasspathContainerInitializer
implements ISourceAttachmentEventListener {
    private final MuleContainersStatusModel containersStatusModel;
    private final ClasspathContainerConfigurer containerConfigurer;
    private final ClasspathContainerCache<IServerDefinition> cache = new ClasspathContainerCache<IServerDefinition>(this::getAssociatedFile);

    public MuleClasspathInitializer() {
        this(EclipseContextHelper.getFromStudioContext(ClasspathContainerConfigurer.class), MuleContainersStatusModel.instance());
        MuleCorePlugin.getEventBus().registerListener(CoreEventTypes.ON_EE_SOURCES_CHANGED, (IEventHandler)this);
    }

    public MuleClasspathInitializer(ClasspathContainerConfigurer containerConfigurer, MuleContainersStatusModel muleContainersStatusModel) {
        this.containerConfigurer = containerConfigurer;
        this.containersStatusModel = muleContainersStatusModel;
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return MuleClasspathContainer.isMuleRuntime(containerPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(IPath originalPath, IJavaProject project) throws CoreException {
        MuleCorePlugin.debugTracer().trace("/debug/classpath-container", originalPath.toString());
        try {
            DefaultMuleClasspathContainer newContainer;
            IServerDefinition serverDefinition = this.getServerDefinition(originalPath, project);
            Optional<List<IClasspathEntry>> cachedEntries = this.cache.get(serverDefinition);
            if (cachedEntries.isPresent()) {
                newContainer = new DefaultMuleClasspathContainer(serverDefinition, cachedEntries.get().toArray(new IClasspathEntry[cachedEntries.get().size()]));
            } else {
                newContainer = new DefaultMuleClasspathContainer(serverDefinition);
                this.cache.storeEntries(serverDefinition, Arrays.asList(newContainer.getClasspathEntries()));
            }
            IPath pathWithVersion = this.getPathWithVersion(originalPath, serverDefinition);
            MuleContainersStatusModel muleContainersStatusModel = this.containersStatusModel;
            synchronized (muleContainersStatusModel) {
                MuleClasspathContainer targetContainer = this.containersStatusModel.bind(pathWithVersion, (MuleClasspathContainer)newContainer, project);
                if (project.getProject().isAccessible()) {
                    this.containerConfigurer.configureContainerInProjects(targetContainer, Collections.singleton(project), originalPath);
                }
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error while initializing classpath container for:" + String.valueOf(originalPath), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkInitialize(IPath pathWithVersion, Collection<IJavaProject> projects) throws CoreException {
        IServerDefinition serverDefinition = this.getServerDefinition(pathWithVersion, projects.iterator().next());
        DefaultMuleClasspathContainer newContainer = new DefaultMuleClasspathContainer(serverDefinition);
        Collection projectsWithGenericPath = CollectionUtils.select(projects, (Predicate)this.usesGenericPath());
        Collection projectsWithPathWithVersion = projectsWithGenericPath.isEmpty() ? projects : CollectionUtils.disjunction(projects, (Collection)projectsWithGenericPath);
        MuleContainersStatusModel muleContainersStatusModel = this.containersStatusModel;
        synchronized (muleContainersStatusModel) {
            MuleClasspathContainer targetContainer = this.containersStatusModel.bind(pathWithVersion, (MuleClasspathContainer)newContainer, projects);
            this.setContainerForProjects(MuleClasspathContainer.getContainerPath(), projectsWithGenericPath, targetContainer);
            this.setContainerForProjects(pathWithVersion, projectsWithPathWithVersion, targetContainer);
        }
    }

    private void setContainerForProjects(IPath containerPath, Collection<IJavaProject> projects, MuleClasspathContainer targetContainer) throws JavaModelException {
        if (!projects.isEmpty()) {
            this.containerConfigurer.configureContainerInProjects(targetContainer, projects, containerPath);
        }
    }

    private Predicate usesGenericPath() {
        return new Predicate(){

            public boolean evaluate(Object object) {
                try {
                    return MuleClasspathContainer.hasGenericMuleClasspathContainer((IJavaProject)object);
                }
                catch (CoreException e) {
                    MuleCorePlugin.logError("Error reading project classpath " + String.valueOf(object), e);
                    return false;
                }
            }
        };
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        IClasspathContainer originalContainer;
        if (MuleClasspathContainer.isMuleRuntime(containerPath) && (originalContainer = this.containerConfigurer.getClasspathContainer(containerPath, project)) instanceof MuleClasspathContainer) {
            MuleClasspathContainer originalMuleContainer = (MuleClasspathContainer)originalContainer;
            MuleClasspathContainer updatedContainer = this.getUpdatedContainer(originalMuleContainer, containerSuggestion);
            this.reassignClasspathContainer(containerPath, project, updatedContainer);
            this.saveSourceAttachmentUpdates(originalMuleContainer, updatedContainer);
        }
    }

    private void saveSourceAttachmentUpdates(MuleClasspathContainer originalContainer, MuleClasspathContainer updatedContainer) {
        List<IClasspathEntry> toSave = this.getUpdatedThirdPartyEntries(originalContainer, updatedContainer);
        SourceAttachmentPreferences preferences = SourceAttachmentPreferences.get();
        for (IClasspathEntry entry : toSave) {
            preferences.setSourceAttachment(updatedContainer.getServerDefinition(), entry.getPath(), entry.getSourceAttachmentPath());
        }
        preferences.save();
    }

    private List<IClasspathEntry> getUpdatedThirdPartyEntries(MuleClasspathContainer originalContainer, MuleClasspathContainer updatedContainer) {
        IClasspathEntry[] originalCommunityEntries = originalContainer.getClasspathEntries(ClasspathEntryKind.THIRDPARTY);
        Map updatedCommunityEntries = Arrays.stream(updatedContainer.getClasspathEntries(ClasspathEntryKind.THIRDPARTY)).collect(Collectors.toMap(entry -> entry.getPath(), Function.identity()));
        ArrayList<IClasspathEntry> toSave = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < originalCommunityEntries.length) {
            IClasspathEntry originalEntry = originalCommunityEntries[i];
            IClasspathEntry updatedEntry = (IClasspathEntry)updatedCommunityEntries.get(originalEntry.getPath());
            if (updatedEntry != null && ProjectClasspathUtils.sourcesChanged(originalEntry, updatedEntry)) {
                toSave.add(updatedEntry);
            }
            ++i;
        }
        return toSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enterpriseSourcesBundleAttachmentChanged(IServerDefinition definition, IPath sourceAttachmentPath) {
        MuleContainersStatusModel muleContainersStatusModel = this.containersStatusModel;
        synchronized (muleContainersStatusModel) {
            Collection<IJavaProject> boundProjects;
            MuleClasspathContainer classpathContainer = this.containersStatusModel.getClasspathContainer(definition.getId());
            if (classpathContainer != null && !(boundProjects = this.containersStatusModel.getBoundProjects(classpathContainer)).isEmpty()) {
                IClasspathContainer containerSuggestion = this.getContainerSuggestion(classpathContainer, sourceAttachmentPath);
                try {
                    IPath containerPath = MuleClasspathContainer.buildContainerPath(definition.getId());
                    MuleClasspathContainer originalMuleContainer = this.containersStatusModel.getClasspathContainer(definition.getId());
                    MuleClasspathContainer updatedContainer = this.getUpdatedContainer(originalMuleContainer, containerSuggestion);
                    this.reassignClasspathContainer(containerPath, boundProjects.iterator().next(), updatedContainer);
                    this.saveSourceAttachmentUpdates(originalMuleContainer, updatedContainer);
                }
                catch (CoreException e) {
                    throw new RuntimeException("There was a problem updating the enterprise sources for " + definition.getLabel(), e);
                }
            }
        }
    }

    private IClasspathContainer getContainerSuggestion(MuleClasspathContainer classpathContainer, IPath sourceAttachmentPath) {
        IClasspathEntry[] classpathEntries = classpathContainer.getClasspathEntries(ClasspathEntryKind.ENTERPRISE);
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(classpathEntries.length);
        IClasspathEntry[] iClasspathEntryArray = classpathEntries;
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
            newEntries.add(JavaCore.newLibraryEntry((IPath)iClasspathEntry.getPath(), (IPath)sourceAttachmentPath, null));
            ++n2;
        }
        return new ContainerSuggestion(classpathContainer.getPath(), newEntries.toArray(new IClasspathEntry[newEntries.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reassignClasspathContainer(IPath containerPath, IJavaProject project, MuleClasspathContainer updatedContainer) throws CoreException {
        MuleContainersStatusModel muleContainersStatusModel = this.containersStatusModel;
        synchronized (muleContainersStatusModel) {
            Collection<IJavaProject> projectsToUpdate = this.containersStatusModel.reassign(this.getPathWithVersion(containerPath, this.getServerDefinition(containerPath, project)), updatedContainer);
            if (!projectsToUpdate.isEmpty()) {
                this.bulkInitialize(containerPath, projectsToUpdate);
            }
        }
    }

    private MuleClasspathContainer getUpdatedContainer(MuleClasspathContainer originalContainer, IClasspathContainer containerSuggestion) throws JavaModelException, CoreException {
        IClasspathEntry[] classpathEntries = ProjectClasspathUtils.getUpdatedClasspathEntries(originalContainer, containerSuggestion);
        return new DefaultMuleClasspathContainer(originalContainer.getServerDefinition(), classpathEntries);
    }

    private IPath getPathWithVersion(IPath originalPath, IServerDefinition serverDefinition) {
        return MuleClasspathContainer.hasVersion(originalPath) ? originalPath : MuleClasspathContainer.buildContainerPath(serverDefinition.getId());
    }

    private IServerDefinition getServerDefinition(IPath containerPath, IJavaProject project) throws CoreException {
        Object muleProject;
        IServerDefinition serverDefinition = null;
        com.google.common.base.Optional<String> runtimeId = MuleClasspathContainer.getRuntimeIdIfPresent(containerPath);
        if (runtimeId.isPresent()) {
            MuleServerManager serverManager = MuleCorePlugin.getServerManager();
            if (serverManager != null) {
                serverDefinition = serverManager.getServerDefinition((String)runtimeId.get());
            }
        } else if (CoreUtils.hasMuleNature(project.getProject()) && (muleProject = MuleRuntime.create(project.getProject())) != null) {
            serverDefinition = muleProject.getServerDefinition();
        }
        return (IServerDefinition)com.google.common.base.Optional.fromNullable(serverDefinition).or((Object)CoreUtils.getDefaultServer());
    }

    private Path getAssociatedFile(IServerDefinition serverDefinition) {
        Path jarLocation = ToolingCachePathUtils.getEditorsCachePath().toFile().toPath();
        Path classloaderFile = jarLocation.getParent().resolve("mule-" + serverDefinition.getVersionWithSuffix() + "-classloader.json");
        return classloaderFile;
    }
}

