/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime;

import com.google.common.base.Optional;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.sources.ClasspathEntryKind;
import org.mule.tooling.core.utils.CoreUtils;

public abstract class MuleClasspathContainer
implements IClasspathContainer {
    protected static final int RUNTIME_ID_SEGMENT_INDEX = 1;
    public static final int SIGNIFICANT_SEGMENTS_COUNT = 2;
    protected static IPath CONTAINER_ID = new Path("MULE_RUNTIME");

    public IClasspathEntry[] getClasspathEntries(ClasspathEntryKind entryKind) {
        IClasspathEntry[] classpathEntries = this.getClasspathEntries();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(classpathEntries.length);
        IClasspathEntry[] iClasspathEntryArray = classpathEntries;
        int n = classpathEntries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entryKind.classifies(this.getServerDefinition(), entry.getPath())) {
                entries.add(entry);
            }
            ++n2;
        }
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    public abstract IServerDefinition getServerDefinition();

    static boolean hasVersion(IPath containerPath) {
        return containerPath.segmentCount() >= 2;
    }

    public static IPath getContainerPath() {
        return CONTAINER_ID;
    }

    public static IPath buildContainerPath(String runtimeId) {
        return new Path(MessageFormat.format("{0}/{1}", CONTAINER_ID, runtimeId));
    }

    public static void addMuleClasspathContainer(IJavaProject javaProject, String runtimeId) throws CoreException {
        if (MuleClasspathContainer.hasMuleClasspathContainer(javaProject, runtimeId)) {
            return;
        }
        IClasspathEntry newContainerEntry = JavaCore.newContainerEntry((IPath)MuleClasspathContainer.buildContainerPath(runtimeId), (boolean)true);
        ProjectClasspathUtils.addNewClasspathEntry(javaProject, newContainerEntry, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean hasMuleClasspathContainer(IJavaProject javaProject, String beforeId) throws CoreException {
        if (javaProject == null || !javaProject.getProject().isAccessible()) {
            return false;
        }
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        boolean isMuleRuntime = false;
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            isMuleRuntime |= MuleClasspathContainer.isExactMuleRuntime(entry, beforeId);
            ++n2;
        }
        return isMuleRuntime;
    }

    public static boolean hasAnyMuleClasspathContainer(List<IClasspathEntry> entries) {
        boolean isMuleRuntime = false;
        for (IClasspathEntry entry : entries) {
            isMuleRuntime |= MuleClasspathContainer.isMuleRuntime(entry);
        }
        return isMuleRuntime;
    }

    public static boolean hasGenericMuleClasspathContainer(IJavaProject javaProject) throws CoreException {
        return MuleClasspathContainer.hasMuleClasspathContainer(javaProject, "");
    }

    public static boolean isExactMuleRuntime(IClasspathEntry entry, String beforeId) {
        if (beforeId == null || beforeId.isEmpty()) {
            return MuleClasspathContainer.isMuleRuntime(entry) && entry.getPath().segmentCount() == 1;
        }
        return MuleClasspathContainer.isMuleRuntime(entry) && entry.getPath().segmentCount() > 1 && entry.getPath().segment(1).equals(beforeId);
    }

    public static boolean isMuleRuntime(IClasspathEntry entry) {
        boolean isMuleRuntime = false;
        IPath entryPath = entry.getPath();
        if (entry.getEntryKind() == 5 && MuleClasspathContainer.isMuleRuntime(entryPath)) {
            isMuleRuntime = true;
        }
        return isMuleRuntime;
    }

    public static boolean isMuleRuntime(IPath entryPath) {
        return CONTAINER_ID.isPrefixOf(entryPath);
    }

    public static String getRuntimeId(IClasspathEntry entry) {
        IPath path = entry.getPath();
        return MuleClasspathContainer.getRuntimeId(path);
    }

    public static String getRuntimeId(IPath path) {
        return (String)MuleClasspathContainer.getRuntimeIdIfPresent(path).or((Object)CoreUtils.getDefaultServerRuntimeId());
    }

    public static Optional<String> getRuntimeIdIfPresent(IPath path) {
        return Optional.fromNullable((Object)path.segment(1));
    }

    public static Optional<MuleClasspathContainer> getClasspathContainer(IMuleProject muleProject) throws JavaModelException {
        String serverId = muleProject.getServerDefinition().getId();
        IPath pathWithId = MuleClasspathContainer.buildContainerPath(serverId);
        MuleClasspathContainer classpathContainer = (MuleClasspathContainer)JavaCore.getClasspathContainer((IPath)pathWithId, (IJavaProject)muleProject.getJavaProject());
        if (classpathContainer == null) {
            classpathContainer = (MuleClasspathContainer)JavaCore.getClasspathContainer((IPath)MuleClasspathContainer.getContainerPath(), (IJavaProject)muleProject.getJavaProject());
        }
        return Optional.fromNullable((Object)classpathContainer);
    }
}

