/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.ClasspathContainerConfigurer;

public class JavaCoreClasspathContainerConfigurer
implements ClasspathContainerConfigurer {
    private static final boolean DEBUG_CLASSPATH_EVENTS = Boolean.getBoolean("org.mule.tooling.core.runtime.classpath");
    private Map<IJavaProject, Set<IPath>> initializingContainers = new ConcurrentHashMap<IJavaProject, Set<IPath>>();

    private static void debug(Runnable runnable) {
        if (DEBUG_CLASSPATH_EVENTS) {
            runnable.run();
        }
    }

    @Override
    public IClasspathContainer getClasspathContainer(IPath containerPath, IJavaProject project) throws JavaModelException {
        return JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)project);
    }

    @Override
    public void configureContainerInProjects(IClasspathContainer targetContainer, Collection<IJavaProject> projects, IPath containerPath) {
        try {
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])projects.toArray(new IJavaProject[projects.size()]), (IClasspathContainer[])this.arrayWithNcopiesOf(projects.size(), targetContainer), null);
        }
        catch (JavaModelException e) {
            String projectNames = projects.stream().map(p -> p.getProject().getName()).collect(Collectors.joining(", "));
            MuleCorePlugin.logError("There was a problem initializing the " + String.valueOf(targetContainer.getPath()) + " classpath container for projects " + projectNames, e);
        }
    }

    private <T> T[] arrayWithNcopiesOf(int size, T ... something) {
        Object[] newArray = Arrays.copyOf(something, size);
        Arrays.fill(newArray, something[0]);
        return newArray;
    }

    @Override
    public IMuleProject getMuleProject(IJavaProject javaProject) {
        return MuleRuntime.create(javaProject.getProject());
    }

    @Override
    public void containerInitializing(IPath containerPath, IJavaProject javaProject) {
        JavaCoreClasspathContainerConfigurer.debug(() -> MuleCorePlugin.logInfo("Start container initialization: " + String.valueOf(this.debugPrint(javaProject, containerPath))));
        this.getContainersFor(javaProject).add(containerPath);
    }

    @Override
    public boolean isContainerInitializing(IPath containerPath, IJavaProject javaProject) {
        boolean result = this.getContainersFor(javaProject).contains(containerPath);
        JavaCoreClasspathContainerConfigurer.debug(() -> MuleCorePlugin.logWarning("Querying initializing state: " + result + " " + String.valueOf(this.debugPrint(javaProject, containerPath))));
        return result;
    }

    @Override
    public void containerInitialized(IPath containerPath, IJavaProject javaProject) {
        this.getContainersFor(javaProject).remove(containerPath);
        JavaCoreClasspathContainerConfigurer.debug(() -> {
            MuleCorePlugin.logInfo("Finished container initialization: " + String.valueOf(this.debugPrint(javaProject, containerPath)));
            MuleCorePlugin.logInfo("Remaining containers to initialize: " + String.valueOf(this.initializingContainers.values().stream().map(x -> x.size()).reduce((x, y) -> x + y).orElse(-1)));
        });
    }

    private Set<IPath> getContainersFor(IJavaProject javaProject) {
        return this.initializingContainers.computeIfAbsent(javaProject, k -> Collections.synchronizedSet(new HashSet()));
    }

    private IPath debugPrint(IJavaProject javaProject, IPath containerPath) {
        return javaProject.getProject().getFullPath().append(containerPath);
    }
}

