/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.core.module.runner.IArtifactResolvingRunner;
import org.mule.tooling.core.module.runner.SingleExtensionCallback;
import org.mule.tooling.core.runtime.ClasspathContainerConfigurer;
import org.mule.tooling.core.runtime.internal.ClasspathContainerCache;
import org.mule.tooling.core.tooling.ToolingCachePathUtils;
import org.mule.tooling.core.utils.ClasspathEntryUtils;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.core.utils.ExternalMuleUserLibraryClasspathContainer;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;
import org.mule.tooling.core.utils.UpdatedMuleUserLibraryClasspathContainer;
import org.mule.tooling.model.project.MuleExtension;

public class ExternalContributionClasspathContainerInitializer
extends ClasspathContainerInitializer {
    private static final String CACHE_FILE_NAME = "studio-classloader-model.json";
    private ClasspathContainerConfigurer classpathContainerConfigurer;
    private IArtifactResolvingRunner artifactResolving;
    private final ClasspathContainerCache<MavenDependency> cache = new ClasspathContainerCache<MavenDependency>(this::getAssociatedFileFrom);

    public ExternalContributionClasspathContainerInitializer() {
        this(EclipseContextHelper.getFromStudioContext(ClasspathContainerConfigurer.class), ArtifactResolvingRunnerFactory.asyncInstance());
    }

    public ExternalContributionClasspathContainerInitializer(ClasspathContainerConfigurer classpathContainerConfigurer, IArtifactResolvingRunner artifactResolving) {
        this.classpathContainerConfigurer = classpathContainerConfigurer;
        this.artifactResolving = artifactResolving;
    }

    public IClasspathContainer getFailureContainer(IPath containerPath, IJavaProject project) {
        if (ExternalContributionClasspathContainerInitializer.isMuleLibraryContainer(containerPath)) {
            this.classpathContainerConfigurer.containerInitializing(containerPath, project);
        }
        return super.getFailureContainer(containerPath, project);
    }

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        MuleCorePlugin.debugTracer().trace("/debug/classpath-container", containerPath.toString());
        if (ExternalContributionClasspathContainerInitializer.isMuleLibraryContainer(containerPath)) {
            IMuleProject muleProject = this.getMuleProject(project);
            if (muleProject == null || !project.getProject().isAccessible()) {
                return;
            }
            MuleExtension muleExtension = ExternalContributionClasspathContainerInitializer.getMuleExtensionFromPath(containerPath, muleProject);
            DependencyResolutionConfiguration includeProvidedScope = DependencyResolutionConfiguration.createDefault().excludeTestScope().excludeProvidedScope();
            MavenDependency extensionMavenInfo = MavenUtils.getDependency(muleExtension);
            this.artifactResolving.runResolvingExtension(muleProject, extensionMavenInfo, SingleExtensionCallback.builder().onSuccess(externalModule -> this.doInitializeClasspathContainer(containerPath, project, muleProject, includeProvidedScope, extensionMavenInfo, (ExternalContributionMuleModule)externalModule)).onError(exceptions -> this.handleExceptions(containerPath, (Map<MavenDependency, List<Exception>>)exceptions)).build(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void doInitializeClasspathContainer(IPath containerPath, IJavaProject project, IMuleProject muleProject, DependencyResolutionConfiguration includeProvidedScope, MavenDependency extensionMavenInfo, ExternalContributionMuleModule externalModule) {
        Optional<List<IClasspathEntry>> cachedEntries = this.cache.get(extensionMavenInfo);
        if (cachedEntries.isPresent()) {
            this.setClasspathContainer(containerPath, project, muleProject, externalModule, cachedEntries.get());
        } else {
            this.artifactResolving.runResolvingDependencies(muleProject, Collections.singletonList(extensionMavenInfo), DependenciesCallback.builder().onSuccess(dependencies -> {
                List<IClasspathEntry> entries = this.collectClasspathEntries((Map<MavenDependency, File>)dependencies);
                ExternalMuleUserLibraryClasspathContainer extClasspathContainer = new ExternalMuleUserLibraryClasspathContainer(externalModule, entries);
                this.cache.storeEntries(extensionMavenInfo, Arrays.asList(extClasspathContainer.getClasspathEntries()));
                this.setClasspathContainer(containerPath, project, muleProject, externalModule, entries);
            }).onError(exceptions -> this.handleExceptions(containerPath, (Map<MavenDependency, List<Exception>>)exceptions)).build(), includeProvidedScope, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public static MuleExtension getMuleExtensionFromPath(IPath containerPath, IMuleProject muleProject) {
        String coordinates = MuleUserLibraryClasspathContainer.getCoordinatesFromPath(containerPath);
        return muleProject.getDeclaredExtensions().stream().filter(extension -> extension.getQualifier().equals(coordinates)).findFirst().orElseGet(() -> new MuleExtension(coordinates, coordinates));
    }

    private void setClasspathContainer(IPath containerPath, IJavaProject project, IMuleProject muleProject, ExternalContributionMuleModule externalModule, List<IClasspathEntry> entries) {
        ExternalMuleUserLibraryClasspathContainer extClasspathContainer = new ExternalMuleUserLibraryClasspathContainer(externalModule, entries);
        if (muleProject.getProject().isAccessible()) {
            try {
                this.classpathContainerConfigurer.configureContainerInProjects(extClasspathContainer, Collections.singletonList(project), containerPath);
            }
            catch (Exception e) {
                MuleCorePlugin.logWarning(String.valueOf(containerPath) + " failed to initialize", e);
            }
        }
    }

    private List<IClasspathEntry> collectClasspathEntries(Map<MavenDependency, File> dependencies) {
        Stream<Map.Entry> nonMulePlugins = dependencies.entrySet().stream().filter(entry -> {
            MavenDependency mavenInfo = (MavenDependency)entry.getKey();
            boolean isCompile = mavenInfo.getScope().equals((Object)MavenDependency.Scope.COMPILE);
            if (!(!isCompile || mavenInfo.getType().isPresent() && mavenInfo.getType().get().equals("pom"))) {
                Boolean isNotMulePlugin = mavenInfo.getClassifier().map(classifier -> !classifier.equals("mule-plugin")).orElse(true);
                return isNotMulePlugin;
            }
            return false;
        });
        return nonMulePlugins.map(entry -> {
            File file = (File)entry.getValue();
            return ClasspathEntryUtils.newLibraryEntryWithNoSourceAttachment((IPath)new Path(file.getAbsolutePath()));
        }).collect(Collectors.toList());
    }

    private void handleExceptions(IPath containerPath, Map<MavenDependency, List<Exception>> exceptions) {
        MuleCorePlugin.logWarning(String.valueOf(containerPath) + " failed to resolve");
        ArtifactResolvingRunnerFactory.ON_ERROR_LOG.accept(exceptions);
    }

    protected IMuleProject getMuleProject(IJavaProject project) {
        return this.classpathContainerConfigurer.getMuleProject(project);
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }

    private ExternalContributionMuleModule resolveExtensionForProject(IPath containerPath, IJavaProject javaProject) throws CoreException {
        IMuleProject muleProject = this.getMuleProject(javaProject);
        if (muleProject != null) {
            List<ExternalContributionMuleModule> matchingModules = CoreUtils.getExternalModulesFromContainerIPath(containerPath, muleProject);
            return !matchingModules.isEmpty() ? matchingModules.get(0) : null;
        }
        return null;
    }

    public static boolean isMuleLibraryContainer(IPath path) {
        return path != null && path.segmentCount() >= 4 && "MULE_LIB".equals(path.segment(0));
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        if (ExternalContributionClasspathContainerInitializer.isMuleLibraryContainer(containerPath)) {
            ExternalContributionMuleModule externalContribution = this.resolveExtensionForProject(containerPath, project);
            if (externalContribution != null) {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)project);
                UpdatedMuleUserLibraryClasspathContainer extClasspathContainer = new UpdatedMuleUserLibraryClasspathContainer(externalContribution, container, containerSuggestion.getClasspathEntries());
                JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{extClasspathContainer}, null);
            } else {
                MuleCorePlugin.getLog().log((IStatus)new Status(1, "org.mule.tooling.core.runtime", String.valueOf(containerPath) + " dependency found in the classpath but not in mule-project.xml, removing from classpath"));
            }
        }
    }

    private java.nio.file.Path getAssociatedFileFrom(MavenDependency mavenDependency) {
        String repositoryPath = MavenResourceUtils.getRepositoryPath(mavenDependency, File.separator);
        java.nio.file.Path jarLocation = ToolingCachePathUtils.getEditorsCachePath().toFile().toPath().resolve(repositoryPath);
        java.nio.file.Path classloaderFile = jarLocation.getParent().resolve(CACHE_FILE_NAME);
        return classloaderFile;
    }
}

