/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime;

import java.util.Arrays;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JarEntryFile;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;

public class ClasspathInitializerHelper {
    public static void refreshRelatedEditors(IMuleProject muleProject, IPath containerPath) {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        Display.getDefault().asyncExec(() -> ClasspathInitializerHelper.doRefresh(muleProject, containerPath));
    }

    private static void doRefresh(IMuleProject muleProject, IPath containerPath) {
        IEditorReference[] editorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        Arrays.stream(editorRefs).filter(editorRef -> {
            IEditorPart editor = editorRef.getEditor(true);
            IEditorInput editorInput = editor.getEditorInput();
            if (editorInput instanceof IStorageEditorInput) {
                IStorageEditorInput entry = (IStorageEditorInput)editorInput;
                try {
                    IStorage storage = entry.getStorage();
                    if (storage instanceof JarEntryFile) {
                        IPackageFragmentRoot packageFragmentRoot = ((JarEntryFile)storage).getPackageFragmentRoot();
                        try {
                            IClasspathContainer classpathContainer = JavaCore.getClasspathContainer((IPath)containerPath, (IJavaProject)muleProject.getJavaProject());
                            IClasspathEntry[] classpathEntries = classpathContainer.getClasspathEntries();
                            return classpathEntries != null && classpathEntries.length > 0 && Arrays.stream(classpathEntries).anyMatch(classpathEntry -> packageFragmentRoot.getPath().equals((Object)classpathEntry.getPath()));
                        }
                        catch (JavaModelException javaModelException) {
                        }
                    }
                }
                catch (CoreException coreException) {}
            } else if (editorInput instanceof NullEditorInput) {
                editor.getSite().getPage().closeEditor(editor, false);
            }
            return false;
        }).map(editorRef -> new OpenEditor(editorRef.getId(), editorRef.getEditor(false))).forEach(ClasspathInitializerHelper::reopen);
    }

    public static void reopen(final OpenEditor openedEditor) {
        if (openedEditor.getEditor() == null) {
            return;
        }
        final IWorkbenchPartSite site = openedEditor.getEditor().getSite();
        final IEditorInput editorInput = openedEditor.getEditor().getEditorInput();
        final String id = openedEditor.getId();
        site.getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = site.getPage();
                if (page != null) {
                    page.closeEditor(openedEditor.getEditor(), false);
                    try {
                        page.openEditor(editorInput, id);
                    }
                    catch (PartInitException e) {
                        MuleCorePlugin.logError("Failed to reopen file", e);
                    }
                }
            }
        });
    }

    private static class OpenEditor {
        private final String id;
        private final IEditorPart editor;

        public OpenEditor(String id, IEditorPart editor) {
            this.id = id;
            this.editor = editor;
        }

        public IEditorPart getEditor() {
            return this.editor;
        }

        public String getId() {
            return this.id;
        }
    }
}

