/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.JarAddedEvent;
import org.mule.tooling.core.event.JarRemovedEvent;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.markers.DependencyResolutionRule;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.runner.IArtifactResolvingRunner;
import org.mule.tooling.core.runtime.ClasspathContainerConfigurer;
import org.mule.tooling.core.runtime.ClasspathInitializerHelper;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.core.utils.ProjectLibsClasspathContainer;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public abstract class BaseClassPathContainerInitializer
extends ClasspathContainerInitializer {
    private static final IClasspathEntry[] EMPTY_ARRAY = new IClasspathEntry[0];
    private final EventBus eventBus;
    private final ClasspathContainerConfigurer containerConfigurer;
    private final Map<IProject, IClasspathEntry[]> resolvedEntriesPerProject = new ConcurrentHashMap<IProject, IClasspathEntry[]>();
    private final Supplier<IArtifactResolvingRunner> resolverRunner;

    public BaseClassPathContainerInitializer(ClasspathContainerConfigurer classpathContainerConfigurer, EventBus eventBus, Optional<IArtifactResolvingRunner> resolvingRunner) {
        this.containerConfigurer = classpathContainerConfigurer;
        this.eventBus = eventBus;
        this.resolverRunner = () -> resolvingRunner.orElseGet(() -> EclipseContextHelper.getFromStudioContext(IArtifactResolvingRunner.class));
        eventBus.registerListener(CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)new IMuleProjectEventListener(){

            @Override
            public void onMuleProjectClosed(IProject project) {
                BaseClassPathContainerInitializer.this.resolvedEntriesPerProject.remove(project);
            }

            @Override
            public void onMuleProjectOpened(IProject project) {
            }
        });
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return this.isThisPathContainer(containerPath);
    }

    public void initialize(IPath containerPath, IJavaProject javaProject, Runnable callback) throws CoreException {
        IMuleProject muleProject;
        if (this.isThisPathContainer(containerPath) && (muleProject = this.containerConfigurer.getMuleProject(javaProject)) != null && muleProject.getProject().isAccessible()) {
            List<MavenDependency> declaredDependencies = muleProject.getDeclaredDependencies();
            if (!declaredDependencies.isEmpty()) {
                this.resolveDependencies(containerPath, muleProject, declaredDependencies, Optional.empty(), callback);
            } else {
                this.scheduleRemoveEntryJob(containerPath, muleProject);
            }
        }
    }

    public void initialize(IPath containerPath, IJavaProject javaProject) throws CoreException {
        this.initialize(containerPath, javaProject, () -> {});
    }

    protected abstract void resolveDependencies(IPath var1, IMuleProject var2, List<MavenDependency> var3, Optional<DependencyResolutionConfiguration> var4, Runnable var5);

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        IClasspathContainer originalContainer;
        if (this.isThisPathContainer(containerPath) && (originalContainer = this.containerConfigurer.getClasspathContainer(containerPath, project)) instanceof ProjectLibsClasspathContainer) {
            IClasspathEntry[] updatedClasspathEntries = ProjectClasspathUtils.getUpdatedClasspathEntries(originalContainer, containerSuggestion);
            this.containerConfigurer.configureContainerInProjects(this.createClassPathContainer(Lists.newArrayList(), updatedClasspathEntries, project), Collections.singleton(project), containerPath);
        }
    }

    protected void scheduleRemoveEntryJob(final IPath containerPath, final IMuleProject muleProject) {
        Job removeJob = new Job("Removing " + ProjectLibsClasspathContainer.CONTAINER_NAME + " from " + muleProject.getProject().getName()){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    BaseClassPathContainerInitializer.this.removeClasspathContainer(containerPath, muleProject);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
        };
        removeJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        removeJob.schedule();
    }

    protected void removeClasspathContainer(IPath containerPath, IMuleProject muleProject) throws CoreException {
        ProjectClasspathUtils.removeClasspathEntry(containerPath, muleProject.getJavaProject(), 1);
        IClasspathEntry[] previousEntries = this.getOrEmptyArray(this.resolvedEntriesPerProject.remove(muleProject.getProject()));
        this.notifyJarChangedEvents(muleProject, EMPTY_ARRAY, previousEntries);
    }

    public void handleDependencyResolutionProblems(IProject project, Map<MavenDependency, List<Exception>> errorsMap) {
        try {
            DependencyResolutionRule.withErrors(errorsMap).apply(project);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem handling error markers for project " + project.getName(), e);
        }
    }

    public void doInitialize(Map<MavenDependency, File> result, IPath containerPath, IMuleProject muleProject, List<MavenDependency> dependencies) {
        List<File> resolvedArtifacts = result.entrySet().stream().filter(this::dependenciesFilter).map(Map.Entry::getValue).filter(Objects::nonNull).collect(Collectors.toList());
        IProject project = muleProject.getProject();
        if (!resolvedArtifacts.isEmpty()) {
            IClasspathEntry[] entries = this.resolveClasspathEntries(muleProject, resolvedArtifacts);
            IClasspathEntry[] previousEntries = this.getOrEmptyArray(this.resolvedEntriesPerProject.put(muleProject.getProject(), entries));
            this.containerConfigurer.configureContainerInProjects(this.createClassPathContainer(dependencies, entries, muleProject.getJavaProject()), Collections.singleton(muleProject.getJavaProject()), containerPath);
            this.notifyJarChangedEvents(muleProject, entries, previousEntries);
        }
        this.clearErrorMarkers(project);
        this.setCancelledDependenciesErrorMarker(result, project);
        ClasspathInitializerHelper.refreshRelatedEditors(muleProject, containerPath);
    }

    private void notifyJarChangedEvents(IMuleProject muleProject, IClasspathEntry[] entries, IClasspathEntry[] previousEntries) {
        Map<IPath, IClasspathEntry> previousEntriesByPath = ProjectClasspathUtils.mapByPath(previousEntries);
        IClasspathEntry[] iClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            boolean wasPresent;
            IClasspathEntry entry2 = iClasspathEntryArray[n2];
            IPath entryPath = entry2.getPath();
            IClasspathEntry previousValue = previousEntriesByPath.remove(entryPath);
            boolean bl = wasPresent = previousValue != null;
            if (!wasPresent) {
                this.eventBus.fireEvent((IEvent)new JarAddedEvent(this.getEntryFile(entry2), muleProject));
            } else if (!previousValue.equals(entry2)) {
                this.notifyIfNativeLibrariesChanged(muleProject, entry2, previousValue);
            }
            ++n2;
        }
        Collection<IClasspathEntry> removedEntries = previousEntriesByPath.values();
        removedEntries.forEach(entry -> this.eventBus.fireEvent((IEvent)new JarRemovedEvent(this.getEntryFile((IClasspathEntry)entry), muleProject)));
    }

    private File getEntryFile(IClasspathEntry entry) {
        File originalFile = entry.getPath().toFile();
        File file = originalFile;
        if (file.isDirectory()) {
            file = this.getNativeLibraryPath(entry).map(File::new).orElseGet(() -> originalFile);
        }
        return file;
    }

    private void notifyIfNativeLibrariesChanged(IMuleProject muleProject, IClasspathEntry entry, IClasspathEntry previousValue) {
        Optional<String> currentNativeLibrary;
        Optional<String> previousNativeLibrary = this.getNativeLibraryPath(previousValue);
        if (!previousNativeLibrary.equals(currentNativeLibrary = this.getNativeLibraryPath(entry))) {
            previousNativeLibrary.ifPresent(path -> this.eventBus.fireEvent((IEvent)new JarRemovedEvent(new File((String)path), muleProject)));
            currentNativeLibrary.ifPresent(path -> this.eventBus.fireEvent((IEvent)new JarAddedEvent(new File((String)path), muleProject)));
        }
    }

    private Optional<String> getNativeLibraryPath(IClasspathEntry entry) {
        IClasspathAttribute[] extraAttributes;
        IClasspathAttribute[] iClasspathAttributeArray = extraAttributes = entry.getExtraAttributes();
        int n = extraAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            String attributeName = attribute.getName();
            if (attributeName == JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY) {
                return Optional.of(attribute.getValue());
            }
            ++n2;
        }
        return Optional.empty();
    }

    private IClasspathEntry[] resolveClasspathEntries(IMuleProject muleProject, List<File> resolvedArtifacts) {
        IServerDefinition serverDefinition = muleProject.getServerDefinition();
        IClasspathEntry[] entries = new IClasspathEntry[resolvedArtifacts.size()];
        int i = 0;
        for (File file : resolvedArtifacts) {
            IClasspathEntry entry;
            if (CoreUtils.isJarFile(file) || CoreUtils.isZipFile(file)) {
                entry = JavaCore.newLibraryEntry((IPath)new Path(file.getAbsolutePath()), (IPath)ProjectClasspathUtils.getSourceAttachment(serverDefinition, (IPath)new Path(file.getAbsolutePath())), null);
            } else {
                if (CoreUtils.isPomFile(file)) continue;
                IClasspathAttribute newClasspathAttribute = JavaCore.newClasspathAttribute((String)JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY, (String)file.getAbsolutePath());
                entry = JavaCore.newLibraryEntry((IPath)new Path(file.getParentFile().getAbsolutePath()), null, null, null, (IClasspathAttribute[])new IClasspathAttribute[]{newClasspathAttribute}, (boolean)false);
            }
            entries[i++] = entry;
        }
        if (entries.length != i) {
            entries = Arrays.copyOfRange(entries, 0, i);
        }
        return entries;
    }

    private void setCancelledDependenciesErrorMarker(Map<MavenDependency, File> result, IProject project) {
        List<MavenDependency> cancelledDependencies = result.entrySet().stream().filter(entry -> entry.getValue() == null).map(entry -> (MavenDependency)entry.getKey()).collect(Collectors.toList());
        try {
            if (!cancelledDependencies.isEmpty()) {
                DependencyResolutionRule.withFailedDependencies(cancelledDependencies).apply(project);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem clearing error markers for dependencies resolution for project " + String.valueOf(project), e);
        }
    }

    protected boolean isMuleExtension(MavenDependency dependency2) {
        return dependency2.getClassifier().map("mule-plugin"::equals).orElse(false);
    }

    protected boolean isAPIDependency(MavenDependency dependency2) {
        return dependency2.getClassifier().map(classifier -> CoreUtils.isAPIClassifier(classifier)).orElse(false);
    }

    protected boolean isRAMLFragmentDependency(MavenDependency dependency2) {
        return dependency2.getClassifier().map("raml-fragment"::equals).orElse(false);
    }

    protected boolean isAsyncAPIDependency(MavenDependency dependency2) {
        return MavenUtils.isAsyncApiSpec(dependency2);
    }

    private void clearErrorMarkers(IProject project) {
        try {
            DependencyResolutionRule.withValidResult().apply(project);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem clearing error markers for dependencies resolution for project " + String.valueOf(project), e);
        }
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }

    private IClasspathEntry[] getOrEmptyArray(IClasspathEntry[] entries) {
        return Optional.ofNullable(entries).orElse(EMPTY_ARRAY);
    }

    protected abstract boolean isThisPathContainer(IPath var1);

    protected abstract IClasspathContainer createClassPathContainer(List<MavenDependency> var1, IClasspathEntry[] var2, IJavaProject var3);

    protected abstract boolean dependenciesFilter(Map.Entry<MavenDependency, File> var1);

    protected IArtifactResolvingRunner getResolverRunner() {
        return this.resolverRunner.get();
    }

    protected ClasspathContainerConfigurer getClassPathContainerConfigurer() {
        return this.containerConfigurer;
    }

    public IClasspathEntry[] getClasspathEntries(IProject project) {
        IClasspathEntry[] result = this.resolvedEntriesPerProject.getOrDefault(project, null);
        if (result != null) {
            result = (IClasspathEntry[])result.clone();
        }
        return result;
    }
}

