/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.model.DependencyToAssetCache;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.core.runtime.ApiSpecClasspathContainer;
import org.mule.tooling.core.runtime.BaseClassPathContainerInitializer;
import org.mule.tooling.core.runtime.ClasspathContainerConfigurer;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.exchange.ExchangeAsset;
import org.mule.tooling.utils.eventbus.EventBus;

public class ApiSpecClasspathContainerInitializer
extends BaseClassPathContainerInitializer {
    public ApiSpecClasspathContainerInitializer() {
        this(EclipseContextHelper.getFromStudioContext(ClasspathContainerConfigurer.class));
    }

    public ApiSpecClasspathContainerInitializer(ClasspathContainerConfigurer classpathContainerConfigurer) {
        this(classpathContainerConfigurer, EclipseContextHelper.getFromStudioContext(EventBus.class));
    }

    public ApiSpecClasspathContainerInitializer(ClasspathContainerConfigurer classpathContainerConfigurer, EventBus eventBus) {
        super(classpathContainerConfigurer, eventBus, Optional.empty());
    }

    @Override
    public IClasspathContainer createClassPathContainer(List<MavenDependency> dependencies, IClasspathEntry[] entries, IJavaProject javaProject) {
        MavenDependency dependency2 = dependencies.get(0);
        CompletableFuture<DependencyToAssetCache.GraphServiceCallResult> assetFrom = DependencyToAssetCache.instance().getAssetFrom(dependency2);
        IClasspathContainer classpathContainer = null;
        classpathContainer = assetFrom.isDone() ? this.buildClasspathContainerFromAsset(entries, dependency2, assetFrom) : this.buildClasspathContainerUntilFutureIsDone(entries, javaProject, dependency2, assetFrom);
        return classpathContainer;
    }

    private IClasspathContainer buildClasspathContainerUntilFutureIsDone(IClasspathEntry[] entries, IJavaProject javaProject, MavenDependency dependency2, CompletableFuture<DependencyToAssetCache.GraphServiceCallResult> assetFrom) {
        ApiSpecClasspathContainer container = new ApiSpecClasspathContainer(dependency2, entries);
        assetFrom.thenAccept(asset -> {
            try {
                ProjectClasspathUtils.reinitializeClasspathContainer(javaProject, container.getPath());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Failed to reinitialize classpath container", e);
            }
        });
        return container;
    }

    private IClasspathContainer buildClasspathContainerFromAsset(IClasspathEntry[] entries, MavenDependency dependency2, CompletableFuture<DependencyToAssetCache.GraphServiceCallResult> assetFrom) {
        try {
            String name = dependency2.getArtifactId();
            DependencyToAssetCache.GraphServiceCallResult assetFromExchange = assetFrom.get();
            if (assetFromExchange.isOk()) {
                name = assetFromExchange.getExchangeAsset().map(ExchangeAsset::getName).orElse(name);
            }
            return new ApiSpecClasspathContainer(dependency2, entries, name);
        }
        catch (InterruptedException | ExecutionException exception) {
            return new ApiSpecClasspathContainer(dependency2, entries);
        }
    }

    @Override
    public boolean dependenciesFilter(Map.Entry<MavenDependency, File> entry) {
        MavenDependency dependency2 = entry.getKey();
        return this.isAPIDependency(dependency2) || this.isRAMLFragmentDependency(dependency2) || this.isAsyncAPIDependency(dependency2);
    }

    public IClasspathContainer getFailureContainer(IPath containerPath, IJavaProject project) {
        this.getClassPathContainerConfigurer().containerInitializing(containerPath, project);
        return super.getFailureContainer(containerPath, project);
    }

    @Override
    public void resolveDependencies(IPath containerPath, IMuleProject muleProject, List<MavenDependency> declaredDependencies, Optional<DependencyResolutionConfiguration> configuration, Runnable callback) {
        String[] segments = containerPath.removeFirstSegments(1).segments();
        DependencyResolutionConfiguration dependencyResolutionConfiguration = configuration.orElse(new DependencyResolutionConfiguration().includeTestScope().includeProvidedScope());
        declaredDependencies.stream().filter(dep -> (this.isAPIDependency((MavenDependency)dep) || this.isAsyncAPIDependency((MavenDependency)dep)) && this.createMavenDependency(dep.getGroupId(), dep.getArtifactId(), dep.getVersion()).equals(this.createMavenDependency(segments))).forEach(dep -> {
            List<MavenDependency> depToResolve = Arrays.asList(dep);
            this.getResolverRunner().runResolvingDependencies(muleProject, depToResolve, DependenciesCallback.builder().onSuccess(resolvedArtifacts -> {
                if (muleProject.getProject().isAccessible()) {
                    this.doInitialize((Map<MavenDependency, File>)resolvedArtifacts, containerPath, muleProject, depToResolve);
                    callback.run();
                }
            }).onError(errorsMap -> this.handleDependencyResolutionProblems(muleProject.getProject(), (Map<MavenDependency, List<Exception>>)errorsMap)).build(), dependencyResolutionConfiguration, (IProgressMonitor)new NullProgressMonitor());
        });
    }

    private MavenDependency createMavenDependency(String ... segments) {
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(segments[0])).withArtifactId(segments[1])).withVersion(segments[2])).build();
    }

    @Override
    protected boolean isThisPathContainer(IPath path) {
        return ApiSpecClasspathContainer.isApiSpec(path);
    }
}

