/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.runtime;

import java.util.Arrays;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;

public class ApiSpecClasspathContainer
extends MuleUserLibraryClasspathContainer {
    private static final String REGEX = ":";
    public static final String API_SPEC_LIB = "org.mule.tooling.API_SPEC_LIB";
    private final IClasspathEntry[] entries;
    private MavenDependency apiSpecDependency;
    private String description;
    private String version;

    public ApiSpecClasspathContainer(MavenDependency dependency2) {
        this(dependency2, new IClasspathEntry[0]);
    }

    public ApiSpecClasspathContainer(MavenDependency dependency2, IClasspathEntry[] entries) {
        this(dependency2, entries, dependency2.getArtifactId());
    }

    public ApiSpecClasspathContainer(MavenDependency dependency2, IClasspathEntry[] entries, String name) {
        super(dependency2.getArtifactId());
        this.apiSpecDependency = dependency2;
        this.description = name;
        this.version = dependency2.getVersion();
        this.entries = entries;
    }

    @Override
    public IClasspathEntry[] getClasspathEntries() {
        return this.entries;
    }

    @Override
    public String getDescription() {
        return this.description + " [v" + this.version + "] ";
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public IPath getPath() {
        return ApiSpecClasspathContainer.getContainerPath(this.apiSpecDependency.getGroupId() + REGEX + this.apiSpecDependency.getArtifactId() + REGEX + this.apiSpecDependency.getVersion());
    }

    public static IPath getContainerPath(MavenDependency mavenDep) {
        return ApiSpecClasspathContainer.getContainerPath(mavenDep.getGroupId() + REGEX + mavenDep.getArtifactId() + REGEX + mavenDep.getVersion());
    }

    public static IPath getContainerPath(String name) {
        return new Path("org.mule.tooling.API_SPEC_LIB/" + ApiSpecClasspathContainer.getContainerPathQualifier(name));
    }

    private static String getContainerPathQualifier(String name) {
        return name.replaceAll(REGEX, PATH_SEPARATOR);
    }

    public static boolean isApiSpec(IClasspathEntry entry) {
        IPath path = entry.getPath();
        return ApiSpecClasspathContainer.isApiSpec(path);
    }

    public static boolean isApiSpec(IPath path) {
        return path != null && path.segmentCount() > 0 && API_SPEC_LIB.equals(path.segment(0));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.apiSpecDependency == null ? 0 : this.apiSpecDependency.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + Arrays.hashCode(this.entries);
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApiSpecClasspathContainer other = (ApiSpecClasspathContainer)obj;
        if (this.apiSpecDependency == null ? other.apiSpecDependency != null : !this.apiSpecDependency.equals(other.apiSpecDependency)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (!Arrays.equals(this.entries, other.entries)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

