/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.requirement;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.tooling.core.requirement.ValidationResult;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.utils.Pair;

public class ValidationResultSet
implements Iterable<Map.Entry<Requirement, ValidationResult>> {
    private final Map<Requirement, ValidationResult> results;

    public ValidationResultSet(Map<Requirement, ValidationResult> results) {
        this.results = results;
    }

    @Override
    public Iterator<Map.Entry<Requirement, ValidationResult>> iterator() {
        return this.results.entrySet().iterator();
    }

    public List<Pair<Requirement, ValidationResult>> getUnsuccessfulRequirements() {
        ArrayList errors = Lists.newArrayList();
        Set<Map.Entry<Requirement, ValidationResult>> entrySet = this.results.entrySet();
        for (Map.Entry<Requirement, ValidationResult> entry : entrySet) {
            if (entry.getValue().isSuccessful()) continue;
            errors.add(Pair.fromEntry(entry));
        }
        return errors;
    }

    public List<Pair<Requirement, ValidationResult>> getSuccessfulRequirements() {
        ArrayList successes = Lists.newArrayList();
        Set<Map.Entry<Requirement, ValidationResult>> entrySet = this.results.entrySet();
        for (Map.Entry<Requirement, ValidationResult> entry : entrySet) {
            if (!entry.getValue().isSuccessful()) continue;
            successes.add(Pair.fromEntry(entry));
        }
        return successes;
    }

    public boolean allPassed() {
        boolean allPassed = true;
        Collection<ValidationResult> values = this.results.values();
        for (ValidationResult validationResult : values) {
            if (validationResult.isSuccessful()) continue;
            allPassed = false;
            break;
        }
        return allPassed;
    }
}

