/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.requirement;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.dependencymanagement.RequirementDependencyManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.requirement.ValidationCallback;
import org.mule.tooling.core.requirement.ValidationResult;
import org.mule.tooling.core.requirement.ValidationResultSet;
import org.mule.tooling.model.module.RequiredAlternatives;
import org.mule.tooling.model.module.RequiredJar;
import org.mule.tooling.model.module.RequiredNativeLibrary;
import org.mule.tooling.model.module.Requirement;
import org.mule.tooling.model.module.RequirementVisitor;

public class RequirementValidator
implements RequirementVisitor {
    private final IMuleProject project;
    private final ValidationCallback<ValidationResult> callback;
    private final ExecutorService executorService;

    public static ValidationResultSet validate(IMuleProject project, Collection<Requirement> requirements) {
        HashMap<Requirement, ValidationResult> results = new HashMap<Requirement, ValidationResult>(requirements.size());
        for (Requirement requirement : requirements) {
            results.put(requirement, RequirementValidator.syncValidate(project, requirement));
        }
        return new ValidationResultSet(results);
    }

    public static ValidationResult syncValidate(IMuleProject project, Requirement requirement) {
        SyncCallback syncCallback = new SyncCallback();
        RequirementValidator.validate(project, requirement, (ValidationCallback<ValidationResult>)syncCallback, false);
        return syncCallback.getResult();
    }

    public static void validate(IMuleProject project, Requirement requirement, ValidationCallback<ValidationResult> callback, boolean runInNewThread) {
        RequirementValidator validatorVisitor = new RequirementValidator(project, callback);
        requirement.accept(validatorVisitor);
    }

    public static void validate(IMuleProject project, Requirement requirement, ValidationCallback<ValidationResult> callback, ExecutorService executorService) {
        RequirementValidator validatorVisitor = new RequirementValidator(project, callback, executorService);
        requirement.accept(validatorVisitor);
    }

    public RequirementValidator(IMuleProject project, ValidationCallback<ValidationResult> callback) {
        this(project, callback, null);
    }

    public RequirementValidator(IMuleProject project, ValidationCallback<ValidationResult> callback, ExecutorService executorService) {
        this.project = project;
        this.executorService = executorService;
        this.callback = callback;
    }

    @Override
    public void visitRequiredNativeLib(RequiredNativeLibrary requiredLibrary) {
        this.runValidation(new ValidateNativeLib(requiredLibrary, this.project, this.callback));
    }

    @Override
    public void visitRequiredJar(RequiredJar requiredJar) {
        if (StringUtils.isNotBlank((String)requiredJar.getFileName()) || StringUtils.isBlank((String)requiredJar.getClassName())) {
            this.runValidation(new ValidateJarByFileName(requiredJar, this.project, this.callback));
        } else {
            this.runValidation(new ValidateJarByClass(requiredJar, this.project, this.callback));
        }
    }

    @Override
    public void visitRequiredAlternatives(RequiredAlternatives requiredAlternatives) {
        List<? extends Requirement> alternatives = requiredAlternatives.getAlternatives();
        AlternativesCallback alternativesCallback = new AlternativesCallback(requiredAlternatives, this.callback);
        for (Requirement requirement : alternatives) {
            RequirementValidator.validate(this.project, requirement, (ValidationCallback<ValidationResult>)alternativesCallback, this.executorService);
        }
    }

    private void runValidation(Runnable validation) {
        if (this.executorService != null) {
            this.executorService.submit(validation);
        } else {
            validation.run();
        }
    }

    private class AlternativesCallback
    implements ValidationCallback<ValidationResult> {
        private final ValidationCallback<ValidationResult> originalCallback;
        private final int totalCount;
        private final RequiredAlternatives alternatives;
        private int alreadyRunCount = 0;
        private boolean alreadySucceded;

        public AlternativesCallback(RequiredAlternatives requiredAlternatives, ValidationCallback<ValidationResult> callback) {
            this.alternatives = requiredAlternatives;
            this.totalCount = requiredAlternatives.getAlternatives().size();
            this.originalCallback = callback;
        }

        @Override
        public synchronized void run(ValidationResult result) {
            ++this.alreadyRunCount;
            if (!this.alreadySucceded) {
                if (result.isSuccessful()) {
                    this.alreadySucceded = true;
                    this.originalCallback.run(result);
                } else if (this.alreadyRunCount == this.totalCount) {
                    ValidationResult failedResult = RequirementDependencyManager.buildUnsuccessfulResult(this.alternatives);
                    this.originalCallback.run(failedResult);
                }
            }
        }
    }

    private static abstract class RequirementValidation<T extends Requirement>
    implements Runnable {
        private final T requirement;
        private final IMuleProject project;
        private final ValidationCallback<ValidationResult> callback;

        public RequirementValidation(T requirement, IMuleProject project, ValidationCallback<ValidationResult> callback) {
            this.requirement = requirement;
            this.project = project;
            this.callback = callback;
        }

        public T getRequirement() {
            return this.requirement;
        }

        public IMuleProject getProject() {
            return this.project;
        }

        public ValidationCallback<ValidationResult> getCallback() {
            return this.callback;
        }

        protected ValidationResult getUnsuccessfulStatus() {
            return RequirementDependencyManager.buildUnsuccessfulResult(this.getRequirement());
        }
    }

    private static class SyncCallback
    implements ValidationCallback<ValidationResult> {
        private ValidationResult result;

        private SyncCallback() {
        }

        @Override
        public void run(ValidationResult result) {
            this.result = result;
        }

        public ValidationResult getResult() {
            return this.result;
        }
    }

    private static class ValidateJarByClass
    extends RequirementValidation<RequiredJar> {
        public ValidateJarByClass(RequiredJar requirement, IMuleProject project, ValidationCallback<ValidationResult> callback) {
            super(requirement, project, callback);
        }

        @Override
        public void run() {
            String className = this.getRequirement() != null ? ((RequiredJar)this.getRequirement()).getClassName() : null;
            try {
                Optional<String> jarPath = this.getJarPathIfInsideClassPath(className, this.getProject());
                boolean success = jarPath.isPresent();
                ValidationResult validationResult = success ? RequirementDependencyManager.buildSuccessResult(this.getProject(), jarPath.get()) : this.getUnsuccessfulStatus();
                this.getCallback().run(validationResult);
            }
            catch (Exception e) {
                MuleCorePlugin.logError("Could not validate if class " + className + " exists in classpath.", e);
            }
        }

        private Optional<String> getJarPathIfInsideClassPath(String className, IMuleProject project) {
            String path = ProjectClasspathUtils.getJarPathIfInsideClassPath(className, project);
            return Optional.ofNullable(path);
        }
    }

    private static class ValidateJarByFileName
    extends RequirementValidation<RequiredJar> {
        public ValidateJarByFileName(RequiredJar requirement, IMuleProject project, ValidationCallback<ValidationResult> callback) {
            super(requirement, project, callback);
        }

        @Override
        public void run() {
            ValidationResult validationResult;
            if (((RequiredJar)this.getRequirement()).isAmbiguous()) {
                validationResult = new ValidationResult(2, "");
            } else {
                IPath successfulMatch = ProjectClasspathUtils.getJarInsideClassPath(((RequiredJar)this.getRequirement()).getFileName(), this.getProject());
                boolean success = successfulMatch != null;
                validationResult = success ? RequirementDependencyManager.buildSuccessResult(this.getProject(), successfulMatch.toOSString()) : this.getUnsuccessfulStatus();
            }
            this.getCallback().run(validationResult);
        }
    }

    private static class ValidateNativeLib
    extends RequirementValidation<RequiredNativeLibrary> {
        public ValidateNativeLib(RequiredNativeLibrary requirement, IMuleProject project, ValidationCallback<ValidationResult> callback) {
            super(requirement, project, callback);
        }

        private String findNativeLibrary() {
            try {
                Collection<String> nativeLibPaths = ProjectClasspathUtils.getProjectNativeLibraryPaths(this.getProject().getJavaProject());
                ArrayList<File> nativeLibFolders = new ArrayList<File>(nativeLibPaths.size());
                for (String string : nativeLibPaths) {
                    File nativeLibFolder = new File(string);
                    nativeLibFolders.add(nativeLibFolder);
                }
                return this.findNativeLibrary(nativeLibFolders.toArray(new File[nativeLibFolders.size()]));
            }
            catch (CoreException e) {
                MuleCorePlugin.logWarning("Could not check existance of native library " + ((RequiredNativeLibrary)this.getRequirement()).getName(), e);
                return null;
            }
        }

        private String findNativeLibrary(File[] nativeLibFolders) {
            File[] fileArray = nativeLibFolders;
            int n = nativeLibFolders.length;
            int n2 = 0;
            while (n2 < n) {
                String nativeLibrary;
                File file = fileArray[n2];
                if (file.getName().equals(((RequiredNativeLibrary)this.getRequirement()).getName())) {
                    return file.getAbsolutePath();
                }
                if (file.isDirectory() && (nativeLibrary = this.findNativeLibrary(file.listFiles())) != null) {
                    return nativeLibrary;
                }
                ++n2;
            }
            return null;
        }

        @Override
        public void run() {
            String libAbsoluteLocation = this.findNativeLibrary();
            boolean exists = libAbsoluteLocation != null;
            ValidationResult validationResult = exists ? RequirementDependencyManager.buildSuccessResult(this.getProject(), libAbsoluteLocation) : this.getUnsuccessfulStatus();
            this.getCallback().run(validationResult);
        }
    }
}

