/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.refactor;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.PomChangedEvent;
import org.mule.tooling.utils.eventbus.IEvent;

final class UpdateMuleProjectNameChange
extends Change {
    private final String newName;
    private final String oldName;

    public UpdateMuleProjectNameChange(String oldName, String newName) {
        this.oldName = oldName;
        this.newName = newName;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Object muleProject = MuleRuntime.create(ResourcesPlugin.getWorkspace().getRoot().getProject(this.newName));
        muleProject.setLabel(this.newName);
        muleProject.save();
        MuleRuntime.removeCached(this.oldName);
        MuleCorePlugin.getEventBus().fireEvent((IEvent)PomChangedEvent.fileChanged((IResource)muleProject.getMuleProjectDescriptorFile(), muleProject.getProject()));
        return new UpdateMuleProjectNameChange(this.newName, this.oldName);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public String getName() {
        return "Update project name in pom.xml";
    }

    public Object getModifiedElement() {
        return null;
    }
}

