/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.refactor;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.refactor.UpdateMuleProjectNameChange;
import org.mule.tooling.core.utils.CoreUtils;

public class MuleProjectNameRenameParticipant
extends RenameParticipant {
    private String oldName;

    protected boolean initialize(Object element) {
        if (element instanceof IProject) {
            IProject project = (IProject)element;
            try {
                return this.doInitialize(project);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError(MessageFormat.format("There was a problem checking project {0} for enabling {1}", project.getName(), ((Object)((Object)this)).getClass().getName()), e);
            }
        }
        return false;
    }

    private boolean doInitialize(IProject project) throws CoreException {
        if (CoreUtils.hasMuleNature(project)) {
            this.oldName = project.getName();
            return true;
        }
        return false;
    }

    public String getName() {
        return "Update project name in pom.xml";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new UpdateMuleProjectNameChange(this.oldName, this.getArguments().getNewName());
    }
}

