/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.refactor;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.refactor.UpdateDomainReferencesChange;

public class DomainProjectRenameParticipant
extends RenameParticipant {
    private IMuleDomainProject domainProject;

    protected boolean initialize(Object element) {
        IProject project;
        if (element instanceof IProject && this.isDomainProject(project = (IProject)element)) {
            IMuleDomainProject domainProject;
            this.domainProject = domainProject = MuleProjectKind.DOMAIN.adapt(project);
            return this.domainHasChildren(domainProject);
        }
        return false;
    }

    private boolean domainHasChildren(IMuleDomainProject domainProject) {
        try {
            return !domainProject.getChildProjects().isEmpty();
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem trying to retrieve the related projects to the domain: " + String.valueOf(domainProject), e);
            return false;
        }
    }

    private boolean isDomainProject(IProject project) {
        try {
            return MuleProjectKind.DOMAIN.classifies(project);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem trying to check the nature of project: " + String.valueOf(project), e);
            return false;
        }
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new UpdateDomainReferencesChange(this.domainProject, this.getArguments().getNewName());
    }

    public String getName() {
        return "Rename domain references in Mule Application projects";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }
}

