/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager.importing;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.mule.tooling.core.packageManager.importing.ImportActionResult;

public interface ProjectImportAction {
    public static final ImportValidationResult EMPTY_VALIDATION_RESULT = new DefaultValidationResult(null, Collections.emptyList());

    default public ImportActionResult runAllActions(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ImportActionResult result = this.run((IProgressMonitor)subMonitor.split(50));
        if (result.isSuccessful()) {
            result = result.getNextAction().map(nextAction -> nextAction.runAllActions((IProgressMonitor)subMonitor.split(50))).orElse(result);
        }
        return result;
    }

    default public ImportValidationResult validateAllActions() {
        ImportValidationResult result = this.validate();
        return result.isSuccessful() ? result.getNextAction().map(next -> next.validate()).orElse(result) : result;
    }

    public ImportActionResult run(IProgressMonitor var1);

    public ImportValidationResult validate();

    public static class DefaultValidationResult
    implements ImportValidationResult {
        private final ProjectImportAction nextAction;
        private final List<String> errorMessages;

        public DefaultValidationResult(ProjectImportAction nextAction, List<String> errorMessages) {
            this.nextAction = nextAction;
            this.errorMessages = errorMessages;
        }

        @Override
        public Optional<ProjectImportAction> getNextAction() {
            return Optional.ofNullable(this.nextAction);
        }

        @Override
        public List<String> getErrorMessages() {
            return this.errorMessages;
        }

        @Override
        public boolean isSuccessful() {
            return this.errorMessages.isEmpty();
        }
    }

    public static interface ImportValidationResult {
        public boolean isSuccessful();

        public Optional<ProjectImportAction> getNextAction();

        public List<String> getErrorMessages();
    }
}

