/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager.importing;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.PomChangedEvent;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.jvm.JVMHelper;
import org.mule.tooling.core.m2.MavenModelHelper;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.m2.ProjectType;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.packageManager.PackagingOptions;
import org.mule.tooling.core.packageManager.importing.ImportActionResult;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.utils.eventbus.IEvent;

public class OpenProjectAction
implements ProjectImportAction {
    private final File rootFile;
    private final String projectName;
    private final JVMHelper jvmHelper;
    private Optional<Boolean> importCanceled = Optional.empty();
    private final String EXTERNAL_TOOL_ID = "org.eclipse.ui.externaltools.ExternalToolBuilder";
    private final String DIALOG_INFO_EXTERNAL_EXECUTION_RESOURCES_TITLE = "Importing Project Information";
    private final String DIALOG_INFO_EXTERNAL_EXECUTION_RESOURCES_DESCRIPTION = "You are importing a project that contains references to executable external resources.\nThe security of these resources cannot be established.\nDo you want to continue?";

    public OpenProjectAction(File rootFile, String projectName) {
        this(rootFile, projectName, new JVMHelper());
    }

    public OpenProjectAction(File rootFile, String projectName, JVMHelper jvmHelper) {
        this.rootFile = rootFile;
        this.projectName = projectName;
        this.jvmHelper = jvmHelper;
    }

    @Override
    public ImportActionResult run(IProgressMonitor monitor) {
        SubMonitor taskMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)("Opening project " + this.projectName), (int)100);
        try {
            IProjectDescription description;
            File dotProject = new File(this.rootFile, ".project");
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(this.projectName);
            File pomFile = new File(this.rootFile, "pom.xml");
            Optional<PomMuleProjectModel> maybePomModel = this.readPomModel(pomFile);
            if (!dotProject.exists()) {
                description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
                URI locationURI = this.rootFile.toURI();
                Path locationPath = new Path(locationURI.getPath());
                Path workspacePath = new Path(ResourcesPlugin.getWorkspace().getRoot().getLocationURI().getPath());
                if (workspacePath.equals((Object)locationPath.removeLastSegments(1))) {
                    locationURI = null;
                }
                description.setLocationURI(locationURI);
                CoreUtils.addNaturesToProjectDescription(description, "org.mule.tooling.core.muleStudioNature", "org.eclipse.jdt.core.javanature");
                CoreUtils.addBuilderToDescription(description, "org.eclipse.jdt.core.javabuilder");
                CoreUtils.addBuilderToDescription(description, "org.mule.tooling.core.muleStudioBuilder");
                if (maybePomModel.isPresent()) {
                    PomMuleProjectModel pomModel = maybePomModel.get();
                    try {
                        if (pomModel.getPackaging().equals("mule-domain")) {
                            CoreUtils.addNaturesToProjectDescription(description, "org.mule.tooling.core.muleStudioDomainNature");
                        }
                        this.updateToDeployableClassifier(pomModel);
                    }
                    catch (IOException e) {
                        MuleCorePlugin.logError("While trying to open a project, it failed to check if it is a domain", e);
                    }
                }
            } else {
                description = project.getWorkspace().loadProjectDescription((IPath)new Path(dotProject.getAbsolutePath()));
                this.verifyProjectDescription(description, monitor);
            }
            description.setName(this.projectName);
            IMuleProject muleProject = MuleRuntime.runLockingProjectsRegistry(() -> {
                project.create(description, (IProgressMonitor)taskMonitor.split(30));
                project.open((IProgressMonitor)taskMonitor.split(40));
                return MuleRuntime.createMuleProject(JavaCore.create((IProject)project), ProjectInitializationData.EmptyData.instance());
            }, this.projectName);
            if (muleProject == null) {
                throw new CoreException(MuleCorePlugin.createStatus(4, "The project can't be imported.", new IllegalArgumentException("Could not create a MuleProject from project " + this.projectName)));
            }
            Optional runtimeQualifier = maybePomModel.flatMap(PomMuleProjectModel::getRuntime);
            MuleRuntime.configureMuleProjectClasspath(muleProject, runtimeQualifier.orElseGet(() -> CoreUtils.getDefaultServer()), this.jvmHelper);
            if (this.projectName != null) {
                muleProject.setLabel(this.projectName);
                MuleCorePlugin.getEventBus().fireEvent((IEvent)PomChangedEvent.fileChanged((IResource)muleProject.getMuleProjectDescriptorFile(), muleProject.getProject()));
            }
            CoreUtils.refreshProject(this.projectName, (IProgressMonitor)taskMonitor.split(30));
            ImportActionResult importActionResult = ImportActionResult.withMuleProject(muleProject);
            return importActionResult;
        }
        catch (Exception e) {
            CoreException coreException;
            if (e instanceof CoreException) {
                coreException = (CoreException)((Object)e);
            } else {
                MuleCorePlugin.logError("The project can't be imported.", e);
                coreException = new CoreException(MuleCorePlugin.createStatus(4, "The project can't be imported.", e));
            }
            ImportActionResult importActionResult = ImportActionResult.withException(coreException);
            return importActionResult;
        }
        finally {
            taskMonitor.done();
        }
    }

    private Optional<PomMuleProjectModel> readPomModel(File pomFile) {
        Optional<PomMuleProjectModel> maybePomModel = Optional.empty();
        if (pomFile.exists()) {
            try {
                maybePomModel = Optional.of(PomMuleProjectModel.create(pomFile, null));
            }
            catch (IOException e) {
                MuleCorePlugin.logError("Error reading POM file '" + pomFile.getAbsolutePath() + "'", e);
            }
        }
        return maybePomModel;
    }

    public void updateToDeployableClassifier(PomMuleProjectModel pomModel) throws FileNotFoundException, IOException {
        MavenModelHelper model = MavenModelHelper.from(pomModel.getPomFile());
        Optional<String> classifier = model.getClassifier(PackagingOptions.DEFAULT);
        classifier.ifPresent(c -> {
            if (ProjectType.MULE_APP.projectType().equals(pomModel.getPackaging())) {
                pomModel.setProjectType(ProjectType.MULE_APP);
            }
        });
    }

    @Override
    public ProjectImportAction.ImportValidationResult validate() {
        LinkedList<String> errorMessages = new LinkedList<String>();
        if (ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName).exists()) {
            errorMessages.add("A project with name \"" + this.projectName + "\" already exists in the workspace");
        }
        return new ProjectImportAction.DefaultValidationResult(null, errorMessages);
    }

    private void verifyProjectDescription(IProjectDescription projectDescription, IProgressMonitor monitor) throws CoreException {
        if (this.hasReferenceToExternalResource(projectDescription)) {
            this.dialogCheckContinueProcess(monitor, "Importing Project Information", "You are importing a project that contains references to executable external resources.\nThe security of these resources cannot be established.\nDo you want to continue?");
            if (this.importCanceled.orElse(false).booleanValue()) {
                Exception externalResourceException = new Exception("The Project has references to executable external resources");
                throw new CoreException(MuleCorePlugin.createStatus(8, externalResourceException.getMessage(), externalResourceException));
            }
        }
    }

    private boolean hasReferenceToExternalResource(IProjectDescription projectDescription) {
        return projectDescription.getBuildSpec() == null ? false : Arrays.stream(projectDescription.getBuildSpec()).filter(x -> "org.eclipse.ui.externaltools.ExternalToolBuilder".equalsIgnoreCase(x.getBuilderName().trim())).findAny().isPresent();
    }

    private void dialogCheckContinueProcess(IProgressMonitor monitor, String title, String description) {
        if (this.importCanceled.isEmpty()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                this.importCanceled = Optional.of(!MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)title, (String)description));
            });
        }
    }

    public void setImportCanceled(boolean responses) {
        this.importCanceled = Optional.of(responses);
    }
}

