/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager.importing;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.packageManager.importing.CompositeImportAction;
import org.mule.tooling.core.packageManager.importing.ExtractProjectAction;
import org.mule.tooling.core.packageManager.importing.ImportActionResult;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;
import org.mule.tooling.core.utils.JarFileHelper;

public class LocateProjectsAction
implements ProjectImportAction {
    private static final List<String> MINIMUM_PROJECT_FILES = Arrays.asList("pom.xml", ".classpath", ".project", "src/main/mule/.*");
    private final File projectFile;
    private File extractDirectory;
    private Map<String, String> projectNames = new HashMap<String, String>();

    public LocateProjectsAction(File projectFile, File extractDirectory) {
        this.projectFile = projectFile;
        this.extractDirectory = extractDirectory;
    }

    @Override
    public ProjectImportAction.ImportValidationResult validate() {
        try {
            LinkedList<String> errorMessages = new LinkedList<String>();
            List<String> availableProjectNames = this.getAvailableProjectNames();
            if (this.getAvailableProjectNames().isEmpty()) {
                errorMessages.add("The file does not contain any projects to import");
            } else {
                for (String name : availableProjectNames) {
                    if (this.isValidProjectName(name)) continue;
                    errorMessages.add("The file does not contain any projects to import");
                }
            }
            ProjectImportAction nextAction = errorMessages.isEmpty() ? this.getNextAction(availableProjectNames) : null;
            return new ProjectImportAction.DefaultValidationResult(nextAction, errorMessages);
        }
        catch (IOException e) {
            return new ProjectImportAction.DefaultValidationResult(null, Arrays.asList("Error while trying to validate file to import: " + e.getMessage()));
        }
    }

    private boolean isValidProjectName(String name) {
        return true;
    }

    public List<String> getAvailableProjectNames() throws IOException {
        List<String> availableNames = Collections.emptyList();
        if (this.getMuleSourceEntry() == null) {
            if (this.hasProjectAtRoot()) {
                String projectName = FilenameUtils.getBaseName((String)this.projectFile.getName());
                availableNames = Arrays.asList(projectName);
            } else {
                List<ZipEntry> minimumProjectEntries = this.getAllEntries("/?[^/]+/", MINIMUM_PROJECT_FILES);
                if (minimumProjectEntries.size() == MINIMUM_PROJECT_FILES.size()) {
                    String projectFirstSegment = this.getEntryPathSegments(minimumProjectEntries.get(0))[0];
                    availableNames = Arrays.asList(projectFirstSegment);
                }
            }
        } else {
            availableNames = this.getStandardPackageProjectNames();
        }
        return availableNames;
    }

    private List<String> getStandardPackageProjectNames() throws IOException {
        LinkedList<String> projectNames = new LinkedList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile projectArchive = new ZipFile(this.projectFile);){
            Enumeration<? extends ZipEntry> entries = projectArchive.entries();
            Pattern projectNamePattern = Pattern.compile("\\/?META-INF\\/mule-src\\/([^\\/]+)\\/?");
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                Matcher entryNameMatcher = projectNamePattern.matcher(entry.getName());
                if (!entryNameMatcher.matches()) continue;
                String projectName = entryNameMatcher.group(1);
                projectNames.add(projectName);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return projectNames;
    }

    @Override
    public ImportActionResult run(IProgressMonitor monitor) {
        ProjectImportAction nextAction = null;
        try {
            List<String> projectNames = this.getAvailableProjectNames();
            if (projectNames.isEmpty()) {
                return ImportActionResult.withException(new CoreException((IStatus)new Status(4, "org.mule.tooling.core", "Invalid archive structure", new IllegalArgumentException().fillInStackTrace())));
            }
            nextAction = this.getNextAction(projectNames);
        }
        catch (IOException e) {
            return ImportActionResult.withException(new CoreException((IStatus)new Status(4, "org.mule.tooling.core", "There was an error while reading project sources from file: " + this.projectFile.getName(), (Throwable)e)));
        }
        return ImportActionResult.withNextAction(nextAction);
    }

    private ProjectImportAction getNextAction(List<String> projectNames) throws IOException {
        ProjectImportAction nextAction;
        if (this.getMuleSourceEntry() != null) {
            List<ProjectImportAction> extractActions = projectNames.stream().map(this::createExtractAction).collect(Collectors.toList());
            nextAction = extractActions.size() > 1 ? new CompositeImportAction(extractActions) : (ProjectImportAction)extractActions.get(0);
        } else {
            String srcProjectName = projectNames.get(0);
            List<String> pathToProjectSources = this.hasProjectAtRoot() ? Collections.emptyList() : Arrays.asList(srcProjectName);
            nextAction = new ExtractProjectAction(this.projectFile, this.getDestProjectName(srcProjectName), pathToProjectSources, this.extractDirectory);
        }
        return nextAction;
    }

    private boolean hasProjectAtRoot() throws IOException {
        List<ZipEntry> minimumProjectEntries = this.getAllEntries("/?", MINIMUM_PROJECT_FILES);
        return minimumProjectEntries.size() == MINIMUM_PROJECT_FILES.size();
    }

    private List<ZipEntry> getAllEntries(String prefix, List<String> files) throws IOException {
        LinkedList<ZipEntry> result = new LinkedList<ZipEntry>();
        List regexes = files.stream().map(file -> prefix + file).collect(Collectors.toList());
        Throwable throwable = null;
        Object var6_7 = null;
        try (ZipFile projectArchive = new ZipFile(this.projectFile);){
            for (String regex : regexes) {
                ZipEntry entry = JarFileHelper.searchForEntry(projectArchive, regex);
                if (entry == null) continue;
                result.add(entry);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private ZipEntry getMuleSourceEntry() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ZipFile projectArchive = new ZipFile(this.projectFile);){
            return JarFileHelper.searchForEntry(projectArchive, "/?META-INF/mule-src/");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private ExtractProjectAction createExtractAction(String srcProjectName) {
        return new ExtractProjectAction(this.projectFile, this.getDestProjectName(srcProjectName), Arrays.asList("META-INF", "mule-src", srcProjectName), this.extractDirectory);
    }

    private String getDestProjectName(String srcProjectName) {
        String destName = this.projectNames.get(srcProjectName);
        return destName != null ? destName : srcProjectName;
    }

    public void rename(String srcProjectName, String destProjectName) {
        this.projectNames.put(srcProjectName, destProjectName);
    }

    private String[] getEntryPathSegments(ZipEntry entry) {
        String separator = Matcher.quoteReplacement(File.separator);
        String entryName = entry.getName().replace("/", separator);
        return entryName.split(separator);
    }
}

