/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager.importing;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;

public class ImportActionResult {
    private final ProjectImportAction nextAction;
    private final CoreException exception;
    private final List<IMuleProject> muleProjects;

    private ImportActionResult(ProjectImportAction nextAction, CoreException exception, List<IMuleProject> muleProject) {
        this.nextAction = nextAction;
        this.exception = exception;
        this.muleProjects = muleProject;
    }

    public static ImportActionResult withNextAction(ProjectImportAction nextAction) {
        return new ImportActionResult(nextAction, null, null);
    }

    public static ImportActionResult withException(CoreException e) {
        return new ImportActionResult(null, e, null);
    }

    public static ImportActionResult withMuleProject(IMuleProject muleProject) {
        return new ImportActionResult(null, null, Arrays.asList(muleProject));
    }

    public static ImportActionResult withMuleProject(List<IMuleProject> muleProjects) {
        return new ImportActionResult(null, null, muleProjects);
    }

    public boolean isSuccessful() {
        return this.exception == null;
    }

    public Optional<ProjectImportAction> getNextAction() {
        return Optional.ofNullable(this.nextAction);
    }

    public Optional<List<IMuleProject>> getMuleProjects() {
        return Optional.ofNullable(this.muleProjects);
    }

    public Optional<CoreException> getException() {
        return Optional.ofNullable(this.exception);
    }
}

