/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager.importing;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.packageManager.importing.ImportActionResult;
import org.mule.tooling.core.packageManager.importing.OpenProjectAction;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;

public class ExtractProjectAction
implements ProjectImportAction {
    private final File projectArchive;
    private final List<String> pathToProjectSources;
    private final File extractDirectory;
    private String destProjectName;

    public ExtractProjectAction(File projectArchive, String destProjectName, List<String> pathToProjectSources, File extractDirectory) {
        this.projectArchive = projectArchive;
        this.destProjectName = destProjectName;
        this.pathToProjectSources = pathToProjectSources;
        this.extractDirectory = extractDirectory;
    }

    @Override
    public ImportActionResult run(IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ZipFile projectArchive = new ZipFile(this.projectArchive);){
                Enumeration<? extends ZipEntry> entries = projectArchive.entries();
                Path basePath = this.extractDirectory.getAbsoluteFile().toPath().normalize();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (!this.isSourceEntryForProject(entry)) continue;
                    File entryDestination = new File(this.extractDirectory, this.getFilePathFromEntry(entry));
                    Path entryPath = entryDestination.getAbsoluteFile().toPath().normalize();
                    if (!entryPath.startsWith(basePath)) {
                        throw new SecurityException("Attempted to write content at illegal location: " + String.valueOf(entryPath.toAbsolutePath()));
                    }
                    if (entry.isDirectory()) {
                        entryDestination.mkdirs();
                        continue;
                    }
                    entryDestination.getParentFile().mkdirs();
                    InputStream in = projectArchive.getInputStream(entry);
                    FileOutputStream out = new FileOutputStream(entryDestination);
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                    IOUtils.closeQuietly((InputStream)in);
                    ((OutputStream)out).close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return ImportActionResult.withException(new CoreException((IStatus)new Status(4, "org.mule.tooling.core", "There was an error while extracting project sources from file: " + this.projectArchive.getName(), (Throwable)e)));
        }
        return ImportActionResult.withNextAction(this.getNextAction());
    }

    private ProjectImportAction getNextAction() {
        return new OpenProjectAction(new File(this.extractDirectory, this.destProjectName), this.destProjectName);
    }

    private boolean isSourceEntryForProject(ZipEntry entry) {
        boolean result = false;
        String[] entryPathSegments = this.getEntryPathSegments(entry);
        if (entryPathSegments.length > this.pathToProjectSources.size()) {
            result = true;
            int i = 0;
            while (result && i < this.pathToProjectSources.size()) {
                result = entryPathSegments[i].equals(this.pathToProjectSources.get(i));
                ++i;
            }
        }
        return result;
    }

    private String getFilePathFromEntry(ZipEntry entry) {
        String[] entryPathSegments = this.getEntryPathSegments(entry);
        StringBuilder filePathBuilder = new StringBuilder(this.destProjectName);
        int i = this.pathToProjectSources.size();
        while (i < entryPathSegments.length) {
            filePathBuilder.append(File.separator);
            filePathBuilder.append(entryPathSegments[i]);
            ++i;
        }
        return filePathBuilder.toString();
    }

    private String[] getEntryPathSegments(ZipEntry entry) {
        String separator = Matcher.quoteReplacement(File.separator);
        String entryName = entry.getName().replaceAll("/", separator);
        String[] entryPathSegments = entryName.split(separator);
        return entryPathSegments;
    }

    public String getSourceProjectName() {
        if (this.pathToProjectSources.size() > 0) {
            return this.pathToProjectSources.get(this.pathToProjectSources.size() - 1);
        }
        return FilenameUtils.getBaseName((String)this.projectArchive.getName());
    }

    public String getDestinationProjectName() {
        return this.destProjectName;
    }

    public File getExtractDirectory() {
        return this.extractDirectory;
    }

    @Override
    public ProjectImportAction.ImportValidationResult validate() {
        LinkedList<String> errorMessages = new LinkedList<String>();
        File destinationFile = new File(this.getExtractDirectory(), this.getDestinationProjectName());
        if (destinationFile.exists()) {
            errorMessages.add("A project with name \"" + this.getDestinationProjectName() + "\" already exists in " + String.valueOf(this.getExtractDirectory()));
        }
        if (destinationFile.canWrite()) {
            errorMessages.add("Cannot write into destination file " + destinationFile.getAbsolutePath());
        }
        ProjectImportAction nextActions = errorMessages.isEmpty() ? this.getNextAction() : null;
        return new ProjectImportAction.DefaultValidationResult(nextActions, errorMessages);
    }
}

