/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager.importing;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.jvm.JVMHelper;
import org.mule.tooling.core.packageManager.importing.ImportActionResult;
import org.mule.tooling.core.packageManager.importing.OpenProjectAction;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;

public class CopyToWorkspaceAction
implements ProjectImportAction {
    private File rootFile;
    private boolean copyToWorkspace;
    private String projectName;
    private JVMHelper jvmHelper;

    public CopyToWorkspaceAction(File rootFile, String projectName, boolean copyToWorkspace) {
        this(rootFile, projectName, copyToWorkspace, new JVMHelper());
    }

    public CopyToWorkspaceAction(File rootFile, String projectName, boolean copyToWorkspace, JVMHelper jvmHelper) {
        this.rootFile = rootFile;
        this.projectName = projectName;
        this.copyToWorkspace = copyToWorkspace;
        this.jvmHelper = jvmHelper;
    }

    @Override
    public ImportActionResult run(IProgressMonitor monitor) {
        File newRootFile = this.rootFile;
        if (this.copyToWorkspace) {
            newRootFile = this.getDestinationProjectRootFile();
            if (newRootFile.exists()) {
                throw new IllegalArgumentException("project " + this.projectName + " already exists as a folder in the workspace");
            }
            try {
                FileUtils.copyDirectory((File)this.rootFile, (File)newRootFile);
            }
            catch (IOException e) {
                return ImportActionResult.withException(new CoreException((IStatus)new Status(4, "org.mule.tooling.core", "An error happened while copying the project to import into the workspace. Project: " + this.projectName, (Throwable)e)));
            }
        }
        return ImportActionResult.withNextAction(this.getNextAction());
    }

    protected ProjectImportAction getNextAction() {
        return new OpenProjectAction(this.getDestinationProjectRootFile(), this.projectName, this.jvmHelper);
    }

    protected File getDestinationProjectRootFile() {
        File newRootFile = this.rootFile;
        if (this.copyToWorkspace) {
            File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
            newRootFile = new File(workspaceRoot, this.projectName);
        }
        return newRootFile;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setCopyToWorkspace(boolean copyToWorkspace) {
        this.copyToWorkspace = copyToWorkspace;
    }

    @Override
    public ProjectImportAction.ImportValidationResult validate() {
        LinkedList<String> errorMessages = new LinkedList<String>();
        if (this.copyToWorkspace) {
            File destinationFile = this.getDestinationProjectRootFile();
            if (destinationFile.exists()) {
                errorMessages.add("A file with name \"" + this.projectName + "\" already exists in the workspace directory");
            }
            if (!destinationFile.getParentFile().canWrite()) {
                errorMessages.add("Cannot write into destination file " + destinationFile.getParent());
            }
        }
        ProjectImportAction nextActions = errorMessages.isEmpty() ? this.getNextAction() : null;
        return new ProjectImportAction.DefaultValidationResult(nextActions, errorMessages);
    }
}

