/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager.importing;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.packageManager.importing.ImportActionResult;
import org.mule.tooling.core.packageManager.importing.ProjectImportAction;
import org.mule.tooling.utils.collection.ListView;

public class CompositeImportAction
implements ProjectImportAction {
    private final List<ProjectImportAction> actions;

    public CompositeImportAction(List<ProjectImportAction> nextActions) {
        this.actions = nextActions;
    }

    public List<ProjectImportAction> getActions() {
        return this.actions;
    }

    @Override
    public ImportActionResult run(IProgressMonitor monitor) {
        ImportActionResult result2;
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.actions.size() * 100));
        List results = this.actions.stream().map(action -> action.run((IProgressMonitor)submonitor.split(100))).collect(Collectors.toList());
        LinkedList<ImportActionResult> successResults = new LinkedList<ImportActionResult>();
        for (ImportActionResult result3 : results) {
            if (!result3.isSuccessful()) {
                return result3;
            }
            successResults.add(result3);
        }
        List<ProjectImportAction> nextActions = successResults.stream().map(result -> result.getNextAction()).filter(action -> action.isPresent()).map(action -> (ProjectImportAction)action.get()).collect(Collectors.toList());
        if (!nextActions.isEmpty()) {
            result2 = ImportActionResult.withNextAction(new CompositeImportAction(nextActions));
        } else {
            List<IMuleProject> muleProjects = successResults.stream().map(r -> r.getMuleProjects()).filter(x -> x.isPresent()).flatMap(action -> ((List)action.get()).stream()).collect(Collectors.toList());
            result2 = ImportActionResult.withMuleProject(muleProjects);
        }
        return result2;
    }

    @Override
    public ProjectImportAction.ImportValidationResult validate() {
        List results = this.actions.stream().map(action -> action.validate()).collect(Collectors.toList());
        List<String> errorMessages = results.stream().map(result -> result.getErrorMessages()).reduce(ListView::of).orElse(Collections.emptyList());
        List<ProjectImportAction> nextActions = results.stream().map(result -> result.getNextAction()).filter(action -> action.isPresent()).map(action -> (ProjectImportAction)action.get()).collect(Collectors.toList());
        CompositeImportAction nextCompositeAction = errorMessages.isEmpty() ? new CompositeImportAction(nextActions) : null;
        return new ProjectImportAction.DefaultValidationResult(nextCompositeAction, errorMessages);
    }
}

