/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager;

public class PackagingOptions {
    public static final PackagingOptions DEFAULT = PackagingOptions.builder().build();
    private final boolean lightweightPackage;
    private final boolean testJar;

    public static Builder builder() {
        return new Builder();
    }

    private PackagingOptions(boolean lightweightPackage, boolean testJar) {
        this.lightweightPackage = lightweightPackage;
        this.testJar = testJar;
    }

    public boolean isLightweightPackage() {
        return this.lightweightPackage;
    }

    public boolean isTestJar() {
        return this.testJar;
    }

    public static class Builder {
        private boolean lightweight;
        private boolean testJar;

        private Builder() {
        }

        public Builder lightweightPackage() {
            return this.lightweightPackage(true);
        }

        public Builder lightweightPackage(boolean lightweight) {
            this.lightweight = lightweight;
            return this;
        }

        public Builder testJar() {
            return this.testJar(true);
        }

        public Builder testJar(boolean testJar) {
            this.testJar = testJar;
            return this;
        }

        public PackagingOptions build() {
            return new PackagingOptions(this.lightweight, this.testJar);
        }
    }
}

