/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager;

import java.io.File;
import java.util.Optional;

public class MuleExportStatus {
    private final String errorMessage;
    private final MuleExportResult result;
    private final Optional<File> exportedProject;

    private MuleExportStatus(String errorMessage, MuleExportResult result) {
        this.errorMessage = errorMessage;
        this.result = result;
        this.exportedProject = Optional.empty();
    }

    private MuleExportStatus(String errorMessage, MuleExportResult result, Optional<File> project) {
        this.errorMessage = errorMessage;
        this.result = result;
        this.exportedProject = project;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public MuleExportResult getResult() {
        return this.result;
    }

    public Optional<File> getExportedProject() {
        return this.exportedProject;
    }

    public Boolean isOk() {
        if (MuleExportResult.OK.equals((Object)this.getResult()) && this.exportedProject.isPresent()) {
            return true;
        }
        return false;
    }

    public static class Builder {
        private MuleExportStatus status;

        public Builder withIOError(String message) {
            this.status = new MuleExportStatus(message, MuleExportResult.IO_ERROR);
            return this;
        }

        public Builder withExportError(String message) {
            this.status = new MuleExportStatus(message, MuleExportResult.EXPORT_ERROR);
            return this;
        }

        public Builder withSuccessfulResult(File file) {
            this.status = new MuleExportStatus("", MuleExportResult.OK, Optional.ofNullable(file));
            return this;
        }

        public Builder withError() {
            this.status = new MuleExportStatus("", MuleExportResult.GENERIC_ERROR);
            return this;
        }

        public Builder withCoreError(String message) {
            this.status = new MuleExportStatus(message, MuleExportResult.CORE_ERROR);
            return this;
        }

        public MuleExportStatus build() {
            return this.status;
        }
    }

    public static enum MuleExportResult {
        IO_ERROR,
        EXPORT_ERROR,
        GENERIC_ERROR,
        CORE_ERROR,
        OK;

    }
}

