/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager;

import java.io.File;
import java.util.Optional;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.mule.tooling.core.deployer.DefaultPackagingRequest;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.packageManager.IExportPackageManager;
import org.mule.tooling.core.packageManager.MuleExportStatus;

public class MuleExportRunnable
implements IRunnableWithProgress {
    private MuleExportStatus exportStatus = null;
    protected IMuleProject muleProject;
    private boolean attachSources;
    private boolean lightWeightPackage;
    private boolean exportParentDomain;
    private boolean onlySources;
    private File outputFile;

    public MuleExportRunnable(IMuleProject project, File outputFile, boolean attachSources, boolean lightWeightPackage, boolean exportParentDomain) {
        this(project, outputFile, attachSources, lightWeightPackage, exportParentDomain, false);
    }

    public MuleExportRunnable(IMuleProject project, File outputFile, boolean attachSources, boolean lightWeightPackage, boolean exportParentDomain, boolean onlySources) {
        this.muleProject = project;
        this.outputFile = outputFile;
        this.attachSources = attachSources;
        this.onlySources = onlySources;
        this.lightWeightPackage = lightWeightPackage;
        this.exportParentDomain = exportParentDomain;
    }

    public void run(IProgressMonitor monitor) {
        DefaultPackagingRequest.Builder packageRequestBuilder = DefaultPackagingRequest.builder(this.muleProject).attachSources(this.attachSources).includeLinkedProjects(this.exportParentDomain).outputFile(this.outputFile).withOnlySources(this.onlySources).withOption("maven.export.skip_all_tests", true);
        if (this.lightWeightPackage) {
            packageRequestBuilder.asLightWeight();
        }
        DefaultPackagingRequest request = packageRequestBuilder.build();
        this.exportStatus = IExportPackageManager.get().export(request, monitor);
    }

    public Optional<File> getResultFile() {
        return this.exportStatus.getExportedProject();
    }

    public boolean wasSuccessfulExport() {
        return this.exportStatus.isOk();
    }

    public MuleExportStatus getExportStatus() {
        return this.exportStatus;
    }
}

