/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.packageManager;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.packageManager.BasePackageManager;

public abstract class BaseExportDelegate
implements BasePackageManager {
    private final String outputPath;
    private File outputFile;

    protected BaseExportDelegate(String outputPath) {
        this.outputPath = outputPath;
    }

    protected File createFolder(File archiveFolder, String folderPath, IProgressMonitor subProgressMonitor) {
        subProgressMonitor.beginTask("creating folder " + String.valueOf(archiveFolder), 5);
        File folder = new File(archiveFolder, folderPath);
        folder.mkdirs();
        subProgressMonitor.done();
        return folder;
    }

    protected void copyResultAndSetOutputFile(IPath tempFile, File destFile) throws IOException {
        if (this.outputPath != null) {
            block10: {
                if (destFile.exists()) {
                    try {
                        FileUtils.forceDelete((File)destFile);
                    }
                    catch (IOException e) {
                        if (!destFile.exists()) break block10;
                        MuleCorePlugin.logError("Failed to delete " + destFile.getAbsolutePath() + ": " + e.getMessage(), e);
                        FileUtils.deleteQuietly((File)destFile);
                    }
                }
            }
            File outFile = tempFile.toFile();
            try {
                try {
                    FileUtils.copyFile((File)outFile, (File)destFile);
                }
                catch (IOException e) {
                    throw new IOException("Failed to write " + destFile.getAbsolutePath() + ": " + e.getMessage(), e);
                }
            }
            finally {
                FileUtils.deleteQuietly((File)outFile);
            }
            this.outputFile = destFile;
        } else {
            this.outputFile = tempFile.toFile();
        }
    }

    protected File createOutputFile(IMuleProject muleProject, String outputFileName) {
        Object fileName = outputFileName == null && muleProject != null ? BaseExportDelegate.getDefaultApplicationJarName(muleProject) : (outputFileName.endsWith(".jar") ? outputFileName : outputFileName + ".jar");
        return new File(this.outputPath, (String)fileName);
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    protected Properties createExportProperties(List<String> projectNames) {
        Properties properties = new Properties();
        properties.setProperty("mule_export_version", "2.0");
        properties.setProperty("mule_exported_projects", StringUtils.join(projectNames, (String)","));
        return properties;
    }

    public static String getDefaultApplicationJarName(IMuleProject muleProject) {
        String fileName = null;
        if (MuleProjectKind.APPLICATION.classifies(muleProject)) {
            String projectName = muleProject.getProject().getName();
            fileName = projectName + ".jar";
        } else if (MuleProjectKind.DOMAIN.classifies(muleProject)) {
            String projectName = DomainUtils.getDeployableArtifactName(muleProject);
            fileName = projectName + ".jar";
        }
        return fileName;
    }
}

