/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.net;

import jakarta.inject.Inject;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.Configuration;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.net.ConnectionManager;
import org.mule.tooling.core.net.ProxyData;
import org.mule.tooling.core.net.StudioProxyManager;

public class StudioProxyAwareConnectionManager
implements ConnectionManager {
    public static final String BASIC = "Basic";
    private static final String USERNAME_PASSWORD_SEPARATOR = ":";
    public static final String BASIC_WITH_SPACE = "Basic ";
    public static final String PROXY_AUTHORIZATION = "Proxy-Authorization";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    private static final String ERROR_MESSAGE = "Invalid URI when trying to select proxy";
    @Inject
    private StudioProxyManager proxyManager;

    public static String proxyAuthHeader(String username, String password) {
        String authenticationValue = username + USERNAME_PASSWORD_SEPARATOR + password;
        return BASIC_WITH_SPACE + Base64.getEncoder().encodeToString(authenticationValue.getBytes());
    }

    @Override
    public CloseableHttpClient createApacheClientForUri(URI uri) {
        Optional<ProxyData> selectedProxy = this.proxyManager.select(uri);
        HttpClientBuilder custom = HttpClients.custom();
        selectedProxy.ifPresent(proxy -> this.setProxyForBuilder((ProxyData)proxy, custom));
        return custom.build();
    }

    private void setProxyForBuilder(ProxyData proxy, HttpClientBuilder custom) {
        proxy.getAuthentication().ifPresent(authenticationData -> {
            UsernamePasswordCredentials usernamePasswordCredentials = new UsernamePasswordCredentials(authenticationData.getUser(), authenticationData.getPassword());
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), (Credentials)usernamePasswordCredentials);
            custom.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        });
        custom.setProxy(new HttpHost(proxy.getHost(), proxy.getPort()));
    }

    @Override
    public Client createJerseyClientForUri(URI uri) {
        return this.createJerseyClientForUri(uri, null);
    }

    @Override
    public Client createJerseyClientForUri(URI uri, Consumer<ClientConfig> configuration) {
        Optional<ProxyData> selectedProxy = this.proxyManager.select(uri);
        ClientConfig clientConfiguration = new ClientConfig();
        if (configuration != null) {
            configuration.accept(clientConfiguration);
        }
        clientConfiguration.connectorProvider((ConnectorProvider)new HttpUrlConnectorProvider().connectionFactory(url -> this.getHttpURLConnection(url, selectedProxy)));
        return ClientBuilder.newClient((Configuration)clientConfiguration);
    }

    @Override
    public URLConnection createUrlConnection(URL url) throws IOException {
        Optional<ProxyData> selectedProxy;
        try {
            selectedProxy = this.proxyManager.select(url.toURI());
        }
        catch (URISyntaxException e) {
            MuleCorePlugin.logError(ERROR_MESSAGE, e);
            selectedProxy = Optional.empty();
        }
        return this.getHttpURLConnection(url, selectedProxy);
    }

    private HttpURLConnection getHttpURLConnection(URL url, Optional<ProxyData> selectedProxy) throws IOException {
        HttpURLConnection urlConnection;
        if (selectedProxy.isPresent()) {
            ProxyData proxyData = selectedProxy.get();
            Proxy urlProxy = new Proxy(proxyData.getType(), new InetSocketAddress(proxyData.getHost(), proxyData.getPort()));
            urlConnection = (HttpURLConnection)url.openConnection(urlProxy);
            proxyData.getAuthentication().ifPresent(authentication -> urlConnection.setRequestProperty(PROXY_AUTHORIZATION, StudioProxyAwareConnectionManager.proxyAuthHeader(authentication.getUser(), authentication.getPassword())));
        } else {
            urlConnection = (HttpURLConnection)url.openConnection();
        }
        return urlConnection;
    }

    @Override
    public List<ProxyData> getAllProxyData() {
        return this.proxyManager.getAllProxyData();
    }

    @Override
    public Optional<ProxyData> getProxyDataForProtocol(ProxyData.Protocol protocol) {
        return this.proxyManager.getProxyDataForProtocol(protocol);
    }
}

