/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.net;

import jakarta.inject.Inject;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Optional;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.net.ProxyData;
import org.mule.tooling.core.net.StudioProxyManager;

public class StudioProxyAuthenticator
extends Authenticator {
    private static final String MALFORMED_URI_EXCEPTION = "Trying to select a proxy for malformed URI: ";
    private static final String ERROR_GENERATING_URL_WITH_REQUEST_DATA = "It was not possible to generate a URL with request data for proxy authentication: ";
    private final StudioProxyManager proxyManager;

    @Inject
    public StudioProxyAuthenticator(StudioProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    @Override
    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication passwordAuthentication = null;
        URL url = Optional.ofNullable(this.getRequestingURL()).orElse(this.buildURLWithProtocolHostAndPort());
        if (url != null) {
            try {
                Optional<ProxyData> proxyData = this.proxyManager.select(url.toURI());
                passwordAuthentication = proxyData.map(ProxyData::getAuthentication).filter(Optional::isPresent).map(Optional::get).map(authData -> new PasswordAuthentication(authData.getUser(), authData.getPassword().toCharArray())).orElse(null);
            }
            catch (URISyntaxException e) {
                MuleCorePlugin.logWarning(MALFORMED_URI_EXCEPTION + url.toString(), e);
            }
        }
        return passwordAuthentication;
    }

    private URL buildURLWithProtocolHostAndPort() {
        URL url = null;
        Object urlString = "";
        if (this.getRequestingProtocol() != null && this.getRequestingHost() != null) {
            try {
                urlString = this.getRequestingProtocol() + "://" + this.getRequestingHost() + ":" + this.getRequestingPort();
                url = new URL((String)urlString);
            }
            catch (MalformedURLException e) {
                MuleCorePlugin.logWarning(ERROR_GENERATING_URL_WITH_REQUEST_DATA + (String)urlString, e);
            }
        }
        return url;
    }
}

