/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.net;

import java.net.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.core.net.ProxyAuthentication;

public interface ProxyData {
    public List<String> getNonProxiedHosts();

    public Protocol getProtocol();

    public String getHost();

    public int getPort();

    public Proxy.Type getType();

    public Optional<ProxyAuthentication> getAuthentication();

    public static enum Protocol {
        HTTP("http", "http.proxyHost", "http.proxyPort", "http.nonProxyHosts", Arrays.asList("com.ning.http.client.AsyncHttpClientConfig.proxy.user", "http.proxyUser", "http.proxyUserName"), Arrays.asList("com.ning.http.client.AsyncHttpClientConfig.proxy.password", "http.proxyPassword")),
        HTTPS("https", "https.proxyHost", "https.proxyPort", null, Arrays.asList("https.proxyUser", "https.proxyUserName"), Arrays.asList("https.proxyPassword")),
        SOCKS("socks", "socksProxyHost", "socksProxyPort", null, Arrays.asList("java.net.socks.username"), Arrays.asList("java.net.socks.password"));

        private String name;
        private String proxyHostSysProperty;
        private String proxyPortSysProperty;
        private String nonProxyHostsSysProperty;
        private List<String> userSystemProperties;
        private List<String> passwordSystemProperties;

        private Protocol(String name, String proxyHostSysProperty, String proxyPortSysProperty, String nonProxyHostsSysProperty, List<String> userSysProperty, List<String> passwordSysProperty) {
            this.name = name;
            this.proxyHostSysProperty = proxyHostSysProperty;
            this.proxyPortSysProperty = proxyPortSysProperty;
            this.nonProxyHostsSysProperty = nonProxyHostsSysProperty;
            this.userSystemProperties = userSysProperty;
            this.passwordSystemProperties = passwordSysProperty;
        }

        public static Optional<Protocol> fromString(String proxyType) {
            Optional<Protocol> protocol = proxyType.equals("HTTP") ? Optional.of(HTTP) : (proxyType.equals("HTTPS") ? Optional.of(HTTPS) : (proxyType.equals("SOCKS") ? Optional.of(SOCKS) : Optional.empty()));
            return protocol;
        }

        public String getHostSystemPropertyKey() {
            return this.proxyHostSysProperty;
        }

        public String getPortSystemPropertyKey() {
            return this.proxyPortSysProperty;
        }

        public Optional<String> getNonProxiesHostSystemPropertyKey() {
            return Optional.ofNullable(this.nonProxyHostsSysProperty);
        }

        public String toString() {
            return this.name;
        }

        public List<String> getUsernameSystemPropertyKeys() {
            return this.userSystemProperties;
        }

        public List<String> getPasswordSystemPropertyKeys() {
            return this.passwordSystemProperties;
        }
    }
}

