/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.net;

import jakarta.inject.Inject;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.core.internal.net.ProxyManager;
import org.eclipse.core.net.proxy.IProxyChangeEvent;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.mule.tooling.core.event.ProxyConfigurationChangedEvent;
import org.mule.tooling.core.net.DefaultProxyData;
import org.mule.tooling.core.net.ProxyData;
import org.mule.tooling.core.net.StudioProxyManager;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.IEvent;

public class DefaultStudioProxyManager
implements StudioProxyManager {
    public static final String GENERAL_LOCAL_RULE = "[::1]";
    public static final String RULE_127_0_0_1 = "127.*";
    public static final String LOCALHOST_RULE = "localhost";
    public static final String LOCAL_WINDOWS_NATIVE_SETTINGS = "<local>";
    private final EventBus eventBus;
    private final ProxyManager proxyService;

    @Inject
    public DefaultStudioProxyManager(EventBus eventBus, IProxyService proxyService) {
        this.eventBus = eventBus;
        if (!(proxyService instanceof ProxyManager)) {
            throw new IllegalArgumentException("Was expecting ProxyManager implementation");
        }
        this.proxyService = (ProxyManager)proxyService;
        proxyService.addProxyChangeListener(this::fireProxyChangedEvent);
    }

    private void fireProxyChangedEvent(IProxyChangeEvent event) {
        this.eventBus.fireEvent((IEvent)new ProxyConfigurationChangedEvent());
    }

    private List<String> getNativeOrManualNonProxyHosts() {
        String[] nonProxiedHosts = Optional.ofNullable(this.proxyService.getNonProxiedHosts()).orElse(new String[0]);
        return Arrays.asList(this.proxyService.isSystemProxiesEnabled() ? this.getNativeNonProxyHosts() : nonProxiedHosts);
    }

    private String[] getNativeNonProxyHosts() {
        String[] nativeNonProxiedHosts = Optional.ofNullable(this.proxyService.getNativeNonProxiedHosts()).orElse(new String[0]);
        Optional<String> localWindows = Arrays.stream(nativeNonProxiedHosts).filter(nonProxyHost -> LOCAL_WINDOWS_NATIVE_SETTINGS.equals(nonProxyHost)).findFirst();
        if (localWindows.isPresent()) {
            nativeNonProxiedHosts = this.removeWindowsLocalAndAddLocalhostBypass(nativeNonProxiedHosts, localWindows.get());
        }
        return nativeNonProxiedHosts;
    }

    private String[] removeWindowsLocalAndAddLocalhostBypass(String[] nativeNonProxiedHosts, String nonProxyHost) {
        List<String> nativeProxies = Arrays.stream(nativeNonProxiedHosts).collect(Collectors.toList());
        nativeProxies.remove(nonProxyHost);
        nativeProxies.add(LOCALHOST_RULE);
        nativeProxies.add(RULE_127_0_0_1);
        nativeProxies.add(GENERAL_LOCAL_RULE);
        return nativeProxies.toArray(new String[nativeProxies.size()]);
    }

    private Optional<IProxyData[]> getNativeOrManualProxyData() {
        return this.proxyService.isSystemProxiesEnabled() ? Optional.ofNullable(this.proxyService.getNativeProxyData()) : Optional.ofNullable(this.proxyService.getProxyData());
    }

    @Override
    public Optional<ProxyData> select(URI uriToConnect) {
        IProxyData[] nonNullProxyDatas = Optional.ofNullable(this.proxyService.select(uriToConnect)).orElse(new IProxyData[0]);
        return Arrays.asList(nonNullProxyDatas).stream().map(proxyData -> DefaultProxyData.fromIProxyData(proxyData, this.getNativeOrManualNonProxyHosts())).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    @Override
    public Optional<ProxyData> getProxyDataForProtocol(ProxyData.Protocol protocol) {
        return this.getAllProxyData().stream().filter(proxyData -> proxyData.getProtocol().equals((Object)protocol)).findFirst();
    }

    @Override
    public List<ProxyData> getAllProxyData() {
        List<ProxyData> resultProxies = new ArrayList<ProxyData>();
        if (this.proxyService.isProxiesEnabled()) {
            resultProxies = this.getNativeOrManualProxyData().map(proxyData -> Arrays.asList(proxyData).stream().map(filteredProxyData -> DefaultProxyData.fromIProxyData(filteredProxyData, this.getNativeOrManualNonProxyHosts())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).orElse(new ArrayList(0));
        }
        return resultProxies;
    }
}

