/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.net;

import java.net.Proxy;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.net.proxy.IProxyData;
import org.mule.tooling.core.net.DefaultProxyAuthentication;
import org.mule.tooling.core.net.ProxyAuthentication;
import org.mule.tooling.core.net.ProxyData;

public class DefaultProxyData
implements ProxyData {
    private List<String> nonProxiedHosts;
    private ProxyData.Protocol protocol;
    private String host;
    private int port;
    private ProxyAuthentication proxyAuthentication;

    public DefaultProxyData(ProxyData.Protocol protocol, String host, int port, List<String> nonProxiedHosts) {
        this(protocol, host, port, nonProxiedHosts, null);
    }

    public DefaultProxyData(ProxyData.Protocol protocol, String host, int port, List<String> nonProxiedHosts, ProxyAuthentication proxyAuthentication) {
        this.nonProxiedHosts = nonProxiedHosts;
        this.protocol = protocol;
        this.host = host;
        this.port = port;
        this.proxyAuthentication = proxyAuthentication;
    }

    @Override
    public List<String> getNonProxiedHosts() {
        return this.nonProxiedHosts;
    }

    @Override
    public ProxyData.Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public Proxy.Type getType() {
        if (this.getProtocol().equals((Object)ProxyData.Protocol.SOCKS)) {
            return Proxy.Type.SOCKS;
        }
        return Proxy.Type.HTTP;
    }

    public static Optional<ProxyData> fromIProxyData(IProxyData proxyData, List<String> nonProxiedHosts) {
        String type = Optional.ofNullable(proxyData.getType()).orElse("");
        Optional<ProxyData.Protocol> protocolFromProxyData = ProxyData.Protocol.fromString(type);
        if (DefaultProxyData.isProxyDataValid(proxyData, protocolFromProxyData)) {
            return Optional.empty();
        }
        DefaultProxyAuthentication authentication = null;
        if (proxyData.isRequiresAuthentication()) {
            authentication = new DefaultProxyAuthentication(proxyData.getUserId(), proxyData.getPassword());
        }
        return Optional.of(new DefaultProxyData(protocolFromProxyData.get(), proxyData.getHost(), proxyData.getPort(), nonProxiedHosts, authentication));
    }

    private static boolean isProxyDataValid(IProxyData proxyData, Optional<ProxyData.Protocol> protocolFromProxyData) {
        return !protocolFromProxyData.isPresent() || proxyData.getHost() == null || proxyData.getPort() == -1 || proxyData.getHost().isEmpty();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.nonProxiedHosts == null ? 0 : this.nonProxiedHosts.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.proxyAuthentication == null ? 0 : this.proxyAuthentication.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultProxyData other = (DefaultProxyData)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.nonProxiedHosts == null ? other.nonProxiedHosts != null : !this.nonProxiedHosts.equals(other.nonProxiedHosts)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.protocol != other.protocol) {
            return false;
        }
        return !(this.proxyAuthentication == null ? other.proxyAuthentication != null : !this.proxyAuthentication.equals(other.proxyAuthentication));
    }

    public String toString() {
        return "DefaultProxyData [nonProxiedHosts=" + String.valueOf(this.nonProxiedHosts) + ", protocol=" + String.valueOf((Object)this.protocol) + ", host=" + this.host + ", port=" + this.port + ", proxyAuthentication=" + String.valueOf(this.proxyAuthentication) + "]";
    }

    @Override
    public Optional<ProxyAuthentication> getAuthentication() {
        return Optional.ofNullable(this.proxyAuthentication);
    }
}

