/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.templates;

import java.io.InputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.module.templates.TemplateConditionEvaluator;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.osgi.framework.Bundle;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TemplateManager {
    private static final String EXT_POINT_TEMPLATE = "org.mule.tooling.core.template";
    static HashMap<String, TemplateDefinition> definitions;
    private static DocumentBuilder documentBuilder;

    public static Document process(Document de) {
        TemplateManager.initDefinitions();
        Element documentElement = de.getDocumentElement();
        TemplateManager.process(documentElement, new HashSet<String>());
        return de;
    }

    private static void process(Element documentElement, HashSet<String> decls) {
        NodeList childNodes = documentElement.getChildNodes();
        int a = 0;
        while (a < childNodes.getLength()) {
            Node item = childNodes.item(a);
            if (item instanceof Element) {
                Element e = (Element)item;
                if (definitions.containsKey(e.getNodeName())) {
                    TemplateManager.processTemplate(e, documentElement, definitions.get(e.getNodeName()), decls);
                }
                TemplateManager.process(e, decls);
            }
            ++a;
        }
    }

    private static void processTemplate(Element e, Element documentElement, TemplateDefinition templateDefinition, HashSet<String> decls) {
        Node item;
        Node cloneNode;
        HashMap<String, String> vars = new HashMap<String, String>();
        int i = 0;
        Object tid = templateDefinition.name;
        String[] stringArray = templateDefinition.variables;
        int n = templateDefinition.variables.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String attribute = e.getAttribute(s);
            if (s.equals("localName")) {
                tid = (String)tid + attribute;
            }
            s.equals("defaultValue");
            if (attribute.length() > 0) {
                vars.put(s, attribute);
            } else {
                String defaultV = templateDefinition.defaults[i];
                if (defaultV.equals("$inherit")) {
                    String attribute2 = e.getOwnerDocument().getDocumentElement().getAttribute("url");
                    vars.put(s, attribute2);
                } else {
                    vars.put(s, defaultV);
                }
            }
            ++i;
            ++n2;
        }
        if (templateDefinition.declarations != null) {
            cloneNode = templateDefinition.declarations.cloneNode(true);
            Element adoptNode = (Element)documentElement.getOwnerDocument().adoptNode(cloneNode);
            TemplateManager.processVars(adoptNode, vars);
            if (templateDefinition.isDeclarationMultiple || !decls.contains(tid)) {
                decls.add((String)tid);
                NodeList childNodes = adoptNode.getChildNodes();
                int a = 0;
                while (a < childNodes.getLength()) {
                    item = childNodes.item(a);
                    if (item instanceof Element) {
                        documentElement.getOwnerDocument().getDocumentElement().appendChild(item);
                    }
                    ++a;
                }
            }
        }
        if (templateDefinition.node != null) {
            cloneNode = templateDefinition.node.cloneNode(true);
            Element adoptNode = (Element)documentElement.getOwnerDocument().adoptNode(cloneNode);
            TemplateManager.processVars(adoptNode, vars);
            NodeList childNodes = adoptNode.getChildNodes();
            int a = 0;
            while (a < childNodes.getLength()) {
                item = childNodes.item(a);
                if (item instanceof Element) {
                    e.getParentNode().insertBefore(item, e);
                }
                ++a;
            }
            e.getParentNode().removeChild(e);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static void processVars(Element adoptNode, Map<String, String> avs) {
        attributes = adoptNode.getAttributes();
        a = 0;
        while (a < attributes.getLength()) {
            item = (Attr)attributes.item(a);
            value = item.getValue();
            nv = new StringBuilder();
            inA = -1;
            i = 0;
            while (i < value.length()) {
                charAt = value.charAt(i);
                if (charAt == '{') {
                    inA = i;
                } else if (charAt == '}') {
                    an = value.substring(inA + 1, i);
                    nv.append(TemplateManager.resolve(an, avs));
                    inA = -1;
                } else if (inA == -1) {
                    nv.append(charAt);
                }
                ++i;
            }
            item.setValue(nv.toString());
            ++a;
        }
        childNodes = adoptNode.getChildNodes();
        toReplace = new ArrayList<AbstractMap.SimpleEntry<Element, Element>>();
        toRemove = new ArrayList<Element>();
        a = 0;
        while (a < childNodes.getLength()) {
            block20: {
                item = childNodes.item(a);
                if (!(item instanceof Element)) break block20;
                e = (Element)item;
                tagName = e.getTagName();
                if (!tagName.equals("if") && !tagName.equals("unless")) ** GOTO lbl-1000
                conditionExpr = e.getAttribute("condition");
                conditionValue = null;
                validCondition = false;
                if (!StringUtils.isBlank((String)conditionExpr)) {
                    conditionValue = avs.get(conditionExpr);
                    validCondition = Boolean.parseBoolean(conditionValue);
                } else {
                    try {
                        conditionValue = e.getAttribute("conditionClass");
                        conditionEvaluator = (TemplateConditionEvaluator)Class.forName(conditionValue).newInstance();
                        validCondition = conditionEvaluator.evaluate(avs);
                    }
                    catch (ClassCastException cce) {
                        throw new RuntimeException("ERROR:: conditionClass (" + conditionValue + ") should implement TemplateConditionEvaluator", cce);
                    }
                    catch (Exception e1) {
                        MuleCorePlugin.logError("There were an error parsing template", e1);
                    }
                }
                children = e.getChildNodes();
                item2 = children.item(0);
                while (!(item2 instanceof Element)) {
                    item2 = item2.getNextSibling();
                }
                inner = (Element)item2;
                TemplateManager.processVars(inner, avs);
                if (conditionValue != null) {
                    invert = tagName.equals("unless");
                    value = invert ^ validCondition;
                    if (value) {
                        toReplace.add(new AbstractMap.SimpleEntry<Element, Element>(e, inner));
                    } else {
                        toRemove.add(e);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    TemplateManager.processVars((Element)item, avs);
                }
            }
            ++a;
        }
        for (Element element : toRemove) {
            adoptNode.removeChild(element);
        }
        for (Map.Entry entry : toReplace) {
            adoptNode.replaceChild((Node)entry.getValue(), (Node)entry.getKey());
        }
    }

    private static Object resolve(String an, Map<String, String> avs) {
        return avs.get(an);
    }

    private static void initDefinitions() {
        if (definitions == null) {
            IConfigurationElement[] elements;
            definitions = new HashMap();
            IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_POINT_TEMPLATE);
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                String attribute = e.getAttribute("path");
                String contributorName = e.getContributor().getName();
                Bundle bundle = Platform.getBundle((String)contributorName);
                URL resource = bundle.getResource(attribute);
                if (resource == null) {
                    throw new IllegalArgumentException("can not find resource with path:" + attribute + " in bundle " + String.valueOf(bundle));
                }
                try {
                    Throwable throwable = null;
                    Object var10_12 = null;
                    try (InputStream stream = resource.openStream();){
                        if (documentBuilder == null) {
                            documentBuilder = XmlFactoryUtils.createSecureDocumentBuilder();
                        }
                        Document parse = documentBuilder.parse(stream);
                        Element documentElement = parse.getDocumentElement();
                        String attribute2 = documentElement.getAttribute("name");
                        definitions.put(attribute2, new TemplateDefinition(parse));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception ex) {
                    throw new IllegalStateException(ex);
                }
                ++n2;
            }
        }
    }

    static class TemplateDefinition {
        protected String[] variables;
        protected String[] defaults;
        protected Element declarations;
        protected Element node;
        protected String name;
        private boolean isDeclarationMultiple;

        public TemplateDefinition(Document de) {
            NodeList elementsByTagName = de.getDocumentElement().getElementsByTagName("argument");
            Element documentElement = de.getDocumentElement();
            this.name = documentElement.getAttribute("name");
            int length = elementsByTagName.getLength();
            this.variables = new String[length];
            this.defaults = new String[length];
            int a = 0;
            while (a < length) {
                Element item = (Element)elementsByTagName.item(a);
                String attribute = item.getAttribute("id");
                String df = item.getAttribute("defaultValue");
                this.variables[a] = attribute;
                this.defaults[a] = df;
                ++a;
            }
            this.postProcessVariables();
            NodeList tag = de.getDocumentElement().getElementsByTagName("tag");
            NodeList defines = de.getDocumentElement().getElementsByTagName("defines");
            if (defines.getLength() > 0) {
                this.declarations = (Element)defines.item(0);
                String requireMultipleDefinitions = this.declarations.getAttribute("multiple");
                this.isDeclarationMultiple = "true".equalsIgnoreCase(requireMultipleDefinitions);
            }
            if (tag.getLength() > 0) {
                this.node = (Element)tag.item(0);
            }
        }

        private void postProcessVariables() {
            int defaultValueIndex = -1;
            int noneLabelIndex = -1;
            int index = 0;
            while (index < this.variables.length && (defaultValueIndex == -1 || noneLabelIndex == -1)) {
                if ("defaultValue".equals(this.variables[index])) {
                    defaultValueIndex = index;
                } else if ("noneLabel".equals(this.variables[index])) {
                    noneLabelIndex = index;
                }
                ++index;
            }
            if (defaultValueIndex != -1 && noneLabelIndex != -1) {
                this.defaults[noneLabelIndex] = "Default";
            }
        }
    }
}

