/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.module.runner;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.runner.Builder;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.core.module.runner.ExtensionsCallback;
import org.mule.tooling.core.module.runner.IArtifactResolvingRunner;
import org.mule.tooling.core.module.runner.SingleExtensionCallback;
import org.mule.tooling.utils.collection.ListView;

public class StateCheckingRunnerDecorator
implements IArtifactResolvingRunner {
    private final IArtifactResolvingRunner decorated;

    public StateCheckingRunnerDecorator(IArtifactResolvingRunner decorated) {
        this.decorated = decorated;
    }

    @Override
    public void runResolvingExtension(IMuleProject muleProject, MavenDependency dependency2, Callback<ExternalContributionMuleModule> callback, IProgressMonitor monitor) {
        this.decorated.runResolvingExtension(muleProject, dependency2, this.decorateCallback(SingleExtensionCallback.copyFrom(callback), callback, muleProject, Arrays.asList(dependency2)), monitor);
    }

    @Override
    public void runResolvingExtensions(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<List<ExternalContributionMuleModule>> callback, IProgressMonitor monitor) {
        this.decorated.runResolvingExtensions(muleProject, dependencies, this.decorateCallback(ExtensionsCallback.copyFrom(callback), callback, muleProject, dependencies), monitor);
    }

    @Override
    public void runResolvingDependencies(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<Map<MavenDependency, File>> callback, IProgressMonitor monitor) {
        this.decorated.runResolvingDependencies(muleProject, dependencies, this.decorateCallback(DependenciesCallback.copyFrom(callback), callback, muleProject, dependencies), monitor);
    }

    @Override
    public void runResolvingDependencies(IMuleProject muleProject, List<MavenDependency> dependencies, Callback<Map<MavenDependency, File>> callback, DependencyResolutionConfiguration configuration, IProgressMonitor monitor) {
        this.decorated.runResolvingDependencies(muleProject, dependencies, this.decorateCallback(DependenciesCallback.copyFrom(callback), callback, muleProject, dependencies), configuration, monitor);
    }

    private <T> Callback<T> decorateCallback(Builder<T> builder, Callback<T> callback, IMuleProject muleProject, List<MavenDependency> dependencies) {
        Predicate<? super MavenDependency> containedInProject = this.getProjectContainmentPredicate(muleProject);
        List requestedPresentDependencies = dependencies.stream().filter(containedInProject).collect(Collectors.toList());
        List requestedAbsentDependencies = dependencies.stream().filter(containedInProject.negate()).collect(Collectors.toList());
        return builder.onSuccess(x -> {
            if (this.isCurrentStateValid(muleProject, requestedPresentDependencies, requestedAbsentDependencies)) {
                callback.onSuccess(x);
            }
        }).onError(x -> {
            if (this.isCurrentStateValid(muleProject, requestedPresentDependencies, requestedAbsentDependencies)) {
                callback.onError((Map<MavenDependency, List<Exception>>)x);
            }
        }).build();
    }

    private boolean isCurrentStateValid(IMuleProject muleProject, List<MavenDependency> requestedPresentDependencies, List<MavenDependency> requestedAbsentDependencies) {
        Predicate<? super MavenDependency> containedInProject = this.getProjectContainmentPredicate(muleProject);
        Predicate<? super MavenDependency> notContainedInProject = containedInProject.negate();
        return requestedPresentDependencies.stream().allMatch(containedInProject) && requestedAbsentDependencies.stream().allMatch(notContainedInProject);
    }

    private Predicate<? super MavenDependency> getProjectContainmentPredicate(IMuleProject muleProject) {
        Map<String, MavenDependency> projectDependenciesCoords = this.mapByRelevantCoords(this.getAllProjectDependencies(muleProject));
        return dep -> projectDependenciesCoords.containsKey(this.getRelevantCoords((MavenDependency)dep));
    }

    private Map<String, MavenDependency> mapByRelevantCoords(List<MavenDependency> allProjectDependencies) {
        return allProjectDependencies.stream().collect(Collectors.toMap(dep -> this.getRelevantCoords((MavenDependency)dep), Function.identity()));
    }

    private String getRelevantCoords(MavenDependency dep) {
        return MavenUtils.getGAV(dep) + ":" + dep.getClassifier().orElse("no-classifier") + ":" + dep.getType().orElse("no-type");
    }

    private List<MavenDependency> getAllProjectDependencies(IMuleProject muleProject) {
        return ListView.of(muleProject.getMuleProjectModel().getMuleExtensions().stream().map(MavenUtils::getDependency).collect(Collectors.toList()), muleProject.getDeclaredDependencies());
    }
}

